/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.utils;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.env.Environment;
import rx.functions.Action2;
import rx.functions.Func1;

public class PropertyResolverUtils {
    private static final HashMap<String, String> PROPERTY_MAPPING = new HashMap();

    public static String getEnvironmentProperty(String text, Environment environment) {
        return PropertyResolverUtils.getEnvironmentProperty(text, environment, (Func1<String, Boolean>)((Func1)PROPERTY_MAPPING::containsKey), (Func1<String, String>)((Func1)PROPERTY_MAPPING::get), (Action2<String, String>)((Action2)PROPERTY_MAPPING::put));
    }

    public static String getEnvironmentPropertyNoCaching(String text, Environment environment) {
        return PropertyResolverUtils.getEnvironmentProperty(text, environment, (Func1<String, Boolean>)((Func1)a -> false), (Func1<String, String>)((Func1)a -> null), (Action2<String, String>)((Action2)(a, b) -> {}));
    }

    public static String getEnvironmentProperty(String text, Environment environment, Func1<String, Boolean> cacheCheckFunc, Func1<String, String> cacheSupplierFunc, Action2<String, String> cacheUpdateFunc) {
        String key;
        String value;
        if (((Boolean)cacheCheckFunc.call((Object)text)).booleanValue()) {
            return (String)cacheSupplierFunc.call((Object)text);
        }
        if (!text.startsWith("$")) {
            cacheUpdateFunc.call((Object)text, (Object)text);
            return text;
        }
        Pattern pattern = Pattern.compile("\\Q${\\E(.+?)\\Q}\\E");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find() && (value = environment.getProperty(key = matcher.group(1))) != null) {
            cacheUpdateFunc.call((Object)text, (Object)value);
            return value;
        }
        cacheUpdateFunc.call((Object)text, (Object)text);
        return text;
    }
}

