/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.leo.aws.ddb.utils.exceptions.Issue;
import org.leo.aws.ddb.utils.exceptions.UtilsException;
import rx.functions.Action0;
import rx.functions.Func1;

public final class Utils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Long MAX_RETRY_INTERVAL_IN_SECONDS_VAL = 30L;
    private static final Thread SHUTDOWN_HOOK = new Thread();
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();

    private Utils() {
    }

    public static <X> List<X> constructListFromJson(Class<X> paramType, String json) {
        return Utils.constructListFromJson(paramType, json, (Func1<Throwable, ? extends RuntimeException>)((Func1)e -> new UtilsException(Issue.INVALID_JSON, "Invalid Json", (Throwable)e)));
    }

    public static <X> List<X> constructListFromJson(Class<X> paramType, String json, Func1<Throwable, ? extends RuntimeException> exceptionFunc) {
        try {
            return (List)OBJECT_MAPPER.readValue(json, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, paramType));
        }
        catch (IOException e) {
            throw (RuntimeException)exceptionFunc.call((Object)e);
        }
    }

    public static <T> T constructFromJson(Class<T> clazz, String json) {
        return Utils.constructFromJson(clazz, json, (Func1<Throwable, ? extends RuntimeException>)((Func1)e -> new UtilsException(Issue.INVALID_JSON, "Invalid Json", (Throwable)e)));
    }

    public static <T> T constructFromJson(Class<T> clazz, String json, Func1<Throwable, ? extends RuntimeException> exceptionFunc) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (IOException e) {
            throw (RuntimeException)exceptionFunc.call((Object)e);
        }
    }

    public static <T> String constructJson(T message) {
        return Utils.constructJson(message, (Func1<Throwable, ? extends RuntimeException>)((Func1)e -> new UtilsException(Issue.JSON_SERIALIZE_ERROR, "Error while constructing json", (Throwable)e)));
    }

    public static <T> String constructJson(T message, Func1<Throwable, ? extends RuntimeException> exceptionFunc) {
        try {
            return OBJECT_MAPPER.writeValueAsString(message);
        }
        catch (JsonProcessingException e) {
            throw (RuntimeException)exceptionFunc.call((Object)e);
        }
    }

    public static void executeUsingLock(Lock lock, Action0 function) {
        lock.lock();
        try {
            function.call();
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T constructObject(Constructor<T> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UtilsException(Issue.INVALID_JSON, (Throwable)e);
        }
    }

    public static <T> T constructObject(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new UtilsException(Issue.INVALID_JSON, (Throwable)e);
        }
    }

    public static Object invokeMethod(String methodName, Class<?> clazz, Object obj, Class<?>[] argTypes, Object[] args) {
        try {
            return argTypes != null && argTypes.length > 0 ? Utils.invokeMethod(clazz.getDeclaredMethod(methodName, argTypes), obj, args) : Utils.invokeMethod(clazz.getDeclaredMethod(methodName, new Class[0]), obj, args);
        }
        catch (NoSuchMethodException e) {
            throw new UtilsException(MessageFormat.format("Method [{0}] not found in class [{1}]: {2}", methodName, clazz, e), (Throwable)e);
        }
    }

    public static Object invokeMethod(Method method, Object obj, Object ... args) {
        method.setAccessible(true);
        try {
            return args != null && args.length > 0 ? method.invoke(obj, args) : method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new UtilsException(MessageFormat.format("Error while invoking method [{0}]: {1}", method.getName(), e), (Throwable)e);
        }
    }

    public static <T> T invokeMethod(Object obj, String methodName) {
        try {
            Method method = Utils.getMethod(obj.getClass(), methodName, new Class[0]);
            return (T)method.invoke(obj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Method getMethod(Class<T> clazz, String methodName, Class<?> ... params) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, params);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            throw new UtilsException(Issue.UNKNOWN_ERROR, (Throwable)e);
        }
    }

    public static <T> T getFromFromFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UtilsException(Issue.UNKNOWN_ERROR, (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            throw t instanceof RuntimeException ? (RuntimeException)t : new UtilsException(Issue.UNKNOWN_ERROR, t);
        }
    }

    public static <T> T constructObject(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return Utils.constructObject(constructor);
        }
        catch (Exception e) {
            throw new UtilsException(Issue.UNKNOWN_ERROR, (Throwable)e);
        }
    }

    public static List<Object> convertArrayToList(Class<?> arrayType, Object value) {
        int length = Array.getLength(value);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < length; ++i) {
            builder.add(Array.get(value, i));
        }
        return builder.build();
    }

    public static String getUnformattedNumber(Number number) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(number);
    }
}

