/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.utils;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.leo.aws.ddb.utils.ITuple;
import org.leo.aws.ddb.utils.Tuple3;
import org.leo.aws.ddb.utils.Tuples;

public final class Tuple<A, B>
implements ITuple {
    private final A first;
    private final B second;

    Tuple(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public A _1() {
        return this.first;
    }

    public B _2() {
        return this.second;
    }

    public Tuple<A, B> _1(A updatedVal) {
        return new Tuple<A, B>(updatedVal, this.second);
    }

    public Tuple<A, B> _2(B updatedVal) {
        return new Tuple<A, B>(this.first, updatedVal);
    }

    public <X, Y> Tuple<X, Y> map(BiFunction<? super A, ? super B, Tuple<X, Y>> mapper) {
        return mapper.apply(this.first, this.second);
    }

    public <C> Tuple3<A, B, C> append(C third) {
        return Tuples.of(this.first, this.second, third);
    }

    @Override
    public Iterable<?> toIterable() {
        return List.of(this.first, this.second);
    }

    public String toString() {
        return "Tuple{first=" + this.first + ", second=" + this.second + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Objects.equals(this.first, tuple.first) && Objects.equals(this.second, tuple.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }
}

