/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.utils;

import java.util.Objects;

public class Page {
    private int size;
    private int totalElements;
    private int totalPages;
    private int currentPage;

    public Page() {
    }

    public Page(int size, int totalElements, int totalPages, int currentPage) {
        this.size = size;
        this.totalElements = totalElements;
        this.totalPages = totalPages;
        this.currentPage = currentPage;
    }

    public int getSize() {
        return this.size;
    }

    public int getTotalElements() {
        return this.totalElements;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return this.size == page.size && this.totalElements == page.totalElements && this.totalPages == page.totalPages && this.currentPage == page.currentPage;
    }

    public static PageBuilder builder() {
        return new PageBuilder();
    }

    public int hashCode() {
        return Objects.hash(this.size, this.totalElements, this.totalPages, this.currentPage);
    }

    public String toString() {
        return "Page{size=" + this.size + ", totalElements=" + this.totalElements + ", totalPages=" + this.totalPages + ", currentPage=" + this.currentPage + "}";
    }

    public static class PageBuilder {
        private int size;
        private int totalElements;
        private int totalPages;
        private int currentPage;

        PageBuilder() {
        }

        public PageBuilder size(int size) {
            this.size = size;
            return this;
        }

        public PageBuilder totalElements(int totalElements) {
            this.totalElements = totalElements;
            return this;
        }

        public PageBuilder totalPages(int totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public PageBuilder currentPage(int currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public Page build() {
            return new Page(this.size, this.totalElements, this.totalPages, this.currentPage);
        }

        public String toString() {
            return "PageBuilder{size=" + this.size + ", totalElements=" + this.totalElements + ", totalPages=" + this.totalPages + ", currentPage=" + this.currentPage + "}";
        }
    }
}

