/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.utils;

import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class ApplicationContextUtils {
    private static volatile ApplicationContextUtils INSTANCE;
    private final ApplicationContext applicationContext;
    private final Environment environment;

    private ApplicationContextUtils(ApplicationContext applicationContext, Environment environment) {
        this.applicationContext = applicationContext;
        this.environment = environment;
    }

    public static ApplicationContextUtils getInstance() {
        return INSTANCE;
    }

    public <T> T getBean(String name) {
        return (T)this.applicationContext.getBean(name);
    }

    public <T> T getBean(Class<T> type) {
        return (T)this.applicationContext.getBean(type);
    }

    public <T> T getBean(Class<T> type, String qualifierName) {
        return (T)this.applicationContext.getBean(qualifierName, type);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init(ApplicationContext applicationContext, Environment environment) {
        if (INSTANCE != null) return;
        Class<ApplicationContextUtils> clazz = ApplicationContextUtils.class;
        synchronized (ApplicationContextUtils.class) {
            if (INSTANCE != null) return;
            INSTANCE = new ApplicationContextUtils(applicationContext, environment);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

