/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.leo.aws.ddb.annotations.DbAttribute;
import org.leo.aws.ddb.exceptions.DbException;
import org.leo.aws.ddb.utils.AttributeValueSerializer;
import org.leo.aws.ddb.utils.Tuple;
import org.leo.aws.ddb.utils.Tuples;
import org.leo.aws.ddb.utils.Utils;
import org.leo.aws.ddb.utils.exceptions.Issue;
import org.leo.aws.ddb.utils.exceptions.UtilsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import rx.functions.Func0;
import rx.functions.Func1;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;

public final class DbUtils {
    private static final TimeZone SERVER_TIME_ZONE = TimeZone.getTimeZone("America/Los_Angeles");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(AttributeValue.class, (JsonSerializer)new AttributeValueSerializer());
        OBJECT_MAPPER.registerModule((Module)module);
    }

    private DbUtils() {
    }

    public static long getItemExpirationByTTLType(String ttlType, long ttlValue) {
        switch (ttlType) {
            case "days": {
                return ZonedDateTime.now(ZoneOffset.UTC).plusDays(ttlValue).toEpochSecond();
            }
            case "hours": {
                return ZonedDateTime.now(ZoneOffset.UTC).plusHours(ttlValue).toEpochSecond();
            }
            case "minutes": {
                return ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(ttlValue).toEpochSecond();
            }
        }
        return ZonedDateTime.now(ZoneOffset.UTC).plusHours(ttlValue).toEpochSecond();
    }

    public static Func1<AttributeValue, Object> attributeToModel(Field field) {
        try {
            Func1 func1;
            if (field.getType().isEnum()) {
                Method valueOf = field.getType().getMethod("valueOf", String.class);
                func1 = a -> ReflectionUtils.invokeMethod((Method)valueOf, null, (Object[])new Object[]{a.s()});
            } else {
                func1 = field.getType() == Long.class || field.getType() == Long.TYPE ? a -> a.n() != null ? Long.valueOf(a.n()) : null : (field.getType() == Integer.class || field.getType() == Integer.TYPE ? a -> Integer.parseInt(a.n()) : (field.getType() == String.class ? AttributeValue::s : (field.getType() == Double.class || field.getType() == Double.TYPE ? a -> Double.parseDouble(a.n()) : (field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? AttributeValue::bool : (field.getType() == Date.class ? attributeValue -> Date.from(ZonedDateTime.parse(attributeValue.s(), DATE_TIME_FORMATTER).toInstant()) : (Set.class.isAssignableFrom(field.getType()) ? a -> DbUtils.attributeToCollection(field, a, (Func0<Collection>)((Func0)() -> new HashSet())) : (List.class.isAssignableFrom(field.getType()) ? a -> DbUtils.attributeToCollection(field, a, (Func0<Collection>)((Func0)() -> new ArrayList())) : (field.getType() == Map.class ? DbUtils::toMappedObject : (field.getType().isArray() ? a -> DbUtils.attributeToArray(field, a) : a -> DbUtils.toMappedObject(field.getType(), a))))))))));
            }
            return func1;
        }
        catch (NoSuchMethodException e) {
            throw new UtilsException(Issue.UNKNOWN_ERROR.name(), (Throwable)e);
        }
    }

    public static Object attributeToArray(Field field, AttributeValue attributeValue) {
        Class<?> arrayType = field.getType();
        Class<?> fieldType = field.getType().getComponentType();
        if (attributeValue.hasSs()) {
            ArrayList set = new ArrayList();
            set.addAll(attributeValue.ss());
            Object arr = Array.newInstance(fieldType, set.size());
            int i = 0;
            while (i < set.size()) {
                Array.set(arr, i, set.get(i));
                ++i;
            }
        } else {
            if (attributeValue.hasNs()) {
                ArrayList set = new ArrayList();
                set.addAll(DbUtils.createValueCollection(attributeValue.ns(), attributeValue, (Func1<Stream, Collection>)((Func1)s -> s.collect(Collectors.toSet())), fieldType));
                Object arr = Array.newInstance(fieldType, set.size());
                int i = 0;
                while (i < set.size()) {
                    Array.set(arr, i, set.get(i));
                    ++i;
                }
                return arr;
            }
            if (attributeValue.hasL()) {
                return DbUtils.toArrayObject(arrayType, attributeValue);
            }
            throw new DbException("UNSUPPORTED_ARRAY_TYPE");
        }
        return null;
    }

    public static Object attributeToCollection(Field field, AttributeValue attributeValue, Func0<Collection> collectionFunc) {
        Collection attToCollection;
        Class<?> fieldType = field.getType();
        if (attributeValue.hasSs()) {
            Collection coll = !fieldType.isInterface() ? (Collection)Utils.constructObject(fieldType) : (Collection)collectionFunc.call();
            coll.addAll(attributeValue.ss());
            attToCollection = coll;
        } else if (attributeValue.hasNs()) {
            Collection coll = !fieldType.isInterface() ? (Collection)Utils.constructObject(fieldType) : (Collection)collectionFunc.call();
            coll.addAll(DbUtils.createValueSet(field, attributeValue.ns(), attributeValue));
            attToCollection = coll;
        } else if (attributeValue.hasL()) {
            Collection coll = !fieldType.isInterface() ? (Collection)Utils.constructObject(fieldType) : (Collection)collectionFunc.call();
            coll.addAll(DbUtils.toListObject(attributeValue, DbUtils.getParameterizedType(field)));
            attToCollection = coll;
        } else {
            throw new DbException("UNSUPPORTED_TYPE_COLLECTION");
        }
        return attToCollection;
    }

    private static Class<?> getParameterizedType(Field field) {
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    private static Collection createValueCollection(Field field, List<String> attributeValueList, AttributeValue attributeValue, Func1<Stream, Collection> collectionFunc) {
        return DbUtils.createValueCollection(attributeValueList, attributeValue, collectionFunc, DbUtils.getParameterizedType(field));
    }

    private static Collection createValueCollection(List<String> attributeValueList, AttributeValue attributeValue, Func1<Stream, Collection> collectionFunc, Class<?> paramType) {
        if (attributeValue.hasSs() && paramType != String.class) {
            throw new DbException("List of string cannot be assigned to list of " + paramType.getSimpleName() + " defined in entity");
        }
        if (attributeValue.hasNs() && paramType != String.class) {
            throw new DbException("List of numbers cannot be assigned to list of " + paramType.getSimpleName() + " defined in entity");
        }
        if (Number.class.isAssignableFrom(paramType)) {
            return (Collection)collectionFunc.call(attributeValueList.stream().map(a -> DbUtils.convertToNumber(paramType, a)));
        }
        throw new DbException("Only Set of String or numbers supported");
    }

    private static Set createValueSet(Field field, List<String> attributeValueList, AttributeValue attributeValue) {
        return (Set)DbUtils.createValueCollection(field, attributeValueList, attributeValue, (Func1<Stream, Collection>)((Func1)s -> s.collect(Collectors.toSet())));
    }

    private static List createValueList(Field field, List<String> attributeValueList, AttributeValue attributeValue) {
        return (List)DbUtils.createValueCollection(field, attributeValueList, attributeValue, (Func1<Stream, Collection>)((Func1)s -> s.collect(Collectors.toList())));
    }

    private static Number convertToNumber(Class numberClass, String value) {
        if (numberClass == Integer.class) {
            return Integer.parseInt(value);
        }
        if (numberClass == Long.class) {
            return Long.parseLong(value);
        }
        if (numberClass == Double.class) {
            return Double.parseDouble(value);
        }
        if (numberClass == BigInteger.class) {
            return BigInteger.valueOf(Long.parseLong(value));
        }
        if (numberClass == BigDecimal.class) {
            return BigDecimal.valueOf(Double.parseDouble(value));
        }
        if (numberClass == AtomicInteger.class) {
            return new AtomicInteger(Integer.parseInt(value));
        }
        if (numberClass == AtomicLong.class) {
            return new AtomicLong(Long.parseLong(value));
        }
        throw new IllegalArgumentException("Invalid Number type or number type not supported");
    }

    private static String convertNumberToString(Number value) {
        Class<?> numberClass = value.getClass();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        if (numberClass == Integer.class || numberClass == Long.class || numberClass == BigInteger.class || numberClass == AtomicInteger.class || numberClass == AtomicLong.class) {
            numberFormat.setMaximumFractionDigits(BigInteger.ZERO.intValue());
            numberFormat.setMinimumFractionDigits(BigInteger.ZERO.intValue());
            return numberFormat.format(value.longValue());
        }
        if (numberClass == Double.class) {
            numberFormat.setMaximumFractionDigits(BigInteger.ZERO.intValue());
            numberFormat.setMinimumFractionDigits(BigInteger.TEN.intValue());
            return numberFormat.format(value);
        }
        if (numberClass == BigDecimal.class) {
            numberFormat.setMaximumFractionDigits(BigInteger.ZERO.intValue());
            numberFormat.setMinimumFractionDigits(BigInteger.TEN.intValue());
            return numberFormat.format(value.doubleValue());
        }
        throw new IllegalArgumentException("Invalid Number type or number type not supported");
    }

    private static Map<String, ?> toMappedObject(AttributeValue attributeValue) {
        return DbUtils.toMappedObject(Map.class, attributeValue);
    }

    private static <T> T toMappedObject(Class<T> mappedClass, AttributeValue attributeValue) {
        try {
            if (attributeValue.hasM()) {
                return (T)Utils.constructFromJson(mappedClass, (String)OBJECT_MAPPER.writeValueAsString((Object)attributeValue));
            }
            throw new DbException("UNKNOWN_TYPE_TO_MAPPED");
        }
        catch (Exception e) {
            throw new DbException(e.getMessage(), e);
        }
    }

    private static List<?> toListObject(AttributeValue attributeValue, Class paramType) {
        try {
            if (attributeValue.hasL()) {
                return Utils.constructListFromJson((Class)paramType, (String)OBJECT_MAPPER.writeValueAsString((Object)attributeValue));
            }
            throw new DbException("UNKNOWN_LIST_TYPE");
        }
        catch (JsonProcessingException e) {
            throw new DbException(e.getMessage(), e);
        }
    }

    private static Object toArrayObject(Class<?> arrayType, AttributeValue attributeValue) {
        try {
            if (attributeValue.hasL()) {
                Object ret = Utils.constructFromJson(arrayType, (String)OBJECT_MAPPER.writeValueAsString((Object)attributeValue));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("return object: " + ret);
                }
                return ret;
            }
            throw new DbException("UNKNOWN_ARRAY_TYPE");
        }
        catch (JsonProcessingException e) {
            throw new DbException(e.getMessage(), e);
        }
    }

    public static Object serializeValue(Field field, Object value) {
        try {
            Object objValue;
            if (field.getType().isEnum()) {
                Method name = field.getType().getMethod("name", new Class[0]);
                objValue = ReflectionUtils.invokeMethod((Method)name, (Object)value);
            } else {
                objValue = value;
            }
            return objValue;
        }
        catch (NoSuchMethodException e) {
            throw new UtilsException("Error while converting enum to string representation", (Throwable)e);
        }
    }

    public static Func1<AttributeValueUpdate.Builder, AttributeValueUpdate.Builder> modelToAttributeUpdateValue(Field field, Object value) {
        AttributeValue.Builder attValueBuilder = AttributeValue.builder();
        Class<?> fieldType = field.getType();
        Object action = value == null ? a -> a.action(AttributeAction.DELETE) : (value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value)) ? a -> a.action(AttributeAction.DELETE) : (fieldType.isArray() ? DbUtils.modelToAttributeUpdateValue(field, Utils.convertArrayToList(fieldType.getComponentType(), (Object)value)) : a -> a.value((AttributeValue)((AttributeValue.Builder)DbUtils.modelToAttributeValue(field, value).call((Object)attValueBuilder)).build())));
        return action;
    }

    public static void checkForNullFields(DbAttribute dbAttribute, Object value, String fieldName) {
        if (dbAttribute != null && !dbAttribute.nullable() && value == null) {
            throw new DbException(String.valueOf(fieldName) + " cannot be null...");
        }
    }

    public static Func1<AttributeValue.Builder, AttributeValue.Builder> modelToAttributeValue(Field field, Object value) {
        Class<?> fieldType = field.getType();
        Func1 paramTypeFuncForList = a -> (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        return DbUtils.modelToAttributeValue(value, fieldType, paramTypeFuncForList);
    }

    public static Func1<AttributeValue.Builder, AttributeValue.Builder> modelToAttributeValue(Object value, Class<?> fieldType, Func1<Collection, Class<?>> paramTypeFuncForList) {
        try {
            Func1<AttributeValue.Builder, AttributeValue.Builder> action;
            if (fieldType.isEnum()) {
                Method name = fieldType.getMethod("name", new Class[0]);
                action = a -> a.s((String)ReflectionUtils.invokeMethod((Method)name, (Object)value));
            } else if (fieldType == String.class) {
                action = a -> a.s(String.valueOf(value));
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                action = a -> a.n(String.valueOf(value));
            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                action = a -> a.n(String.valueOf(value));
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                action = a -> a.n(String.valueOf(value));
            } else if (fieldType == Number.class) {
                action = a -> a.n(String.valueOf(value));
            } else if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                action = a -> a.bool((Boolean)value);
            } else if (fieldType == Date.class) {
                action = a -> a.s(((Date)value).toInstant().atZone(SERVER_TIME_ZONE.toZoneId()).format(DATE_TIME_FORMATTER));
            } else if (Collection.class.isAssignableFrom(fieldType)) {
                action = DbUtils.getAttributeValueFromList((Collection)value, paramTypeFuncForList);
            } else if (Map.class.isAssignableFrom(fieldType)) {
                action = a -> a.m(DbUtils.getAttributeValueFromMap((Map)value));
            } else if (fieldType.isArray()) {
                List listVals = Utils.convertArrayToList(fieldType.getComponentType(), (Object)value);
                action = DbUtils.getAttributeValueFromList(listVals, l -> fieldType.getComponentType());
            } else {
                action = a -> a.m(DbUtils.getAttributeValueFromMap((Map)Utils.constructFromJson(Map.class, (String)Utils.constructJson((Object)value))));
            }
            return action;
        }
        catch (NoSuchMethodException e) {
            throw new UtilsException(Issue.UNKNOWN_ERROR, (Throwable)e);
        }
    }

    private static Func1<AttributeValue.Builder, AttributeValue.Builder> getAttributeValueFromList(Collection values, Func1<Collection, Class<?>> paramTypeFunc) {
        Func1 action;
        Class paramType = (Class)paramTypeFunc.call((Object)values);
        if (paramType == String.class) {
            action = a -> a.ss(values.toArray(new String[0]));
        } else if (Number.class.isAssignableFrom(paramType)) {
            action = a -> a.ns(values.stream().map(DbUtils::convertNumberToString).collect(Collectors.toList()).toArray(new String[0]));
        } else {
            Stream<Object> attList = values.stream().map(b -> AttributeValue.builder().m(DbUtils.getAttributeValueFromMap((Map)Utils.constructFromJson(Map.class, (String)Utils.constructJson((Object)b)))).build());
            action = a -> a.l((Collection)attList.collect(Collectors.toList()));
        }
        return action;
    }

    public static Map<String, AttributeValue> getAttributeValueFromMap(Map<String, Object> valuesMap) {
        Map<String, AttributeValue> attributeValueMap = valuesMap.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> DbUtils.getStringAttributeValueFromMapEntry(entry)).collect(Collectors.toMap(Tuple::_1, Tuple::_2));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("attributeValueMap: " + attributeValueMap);
        }
        return attributeValueMap;
    }

    private static Tuple<String, AttributeValue> getStringAttributeValueFromMapEntry(Map.Entry<String, Object> entry) {
        AttributeValue.Builder builder = AttributeValue.builder();
        Object value = entry.getValue();
        return Tuples.of((Object)entry.getKey(), (Object)((AttributeValue)((AttributeValue.Builder)DbUtils.modelToAttributeValue(value, value.getClass(), list -> {
            if (CollectionUtils.isEmpty((Collection)list)) {
                return String.class;
            }
            return list.iterator().next().getClass();
        }).call((Object)builder)).build()));
    }

    public static List<Tuple<String, AttributeValueUpdate>> getUpdatedTime(Map<String, Object> updatedValues, Func0<Tuple<String, Field>> dateUpdateFieldTupleFunc) {
        Tuple dateUpdateFieldTuple = (Tuple)dateUpdateFieldTupleFunc.call();
        if (dateUpdateFieldTuple != null && !updatedValues.containsKey(dateUpdateFieldTuple._1())) {
            Tuple tuple = Tuples.of((Object)((String)dateUpdateFieldTuple._1()), (Object)((AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)AttributeValue.builder().s(ZonedDateTime.now(SERVER_TIME_ZONE.toZoneId()).format(DATE_TIME_FORMATTER)).build()).build()));
            return Collections.singletonList(tuple);
        }
        return Collections.emptyList();
    }

    public static String formatDynamoDbDate(Date date) {
        return date.toInstant().atZone(SERVER_TIME_ZONE.toZoneId()).format(DATE_TIME_FORMATTER);
    }

    public static Date parseDynamoDbDate(String formattedDate) {
        return Date.from(ZonedDateTime.parse(formattedDate, DATE_TIME_FORMATTER).toInstant());
    }

    public static Map<String, Object> convertAttributeValueToMap(AttributeValue attributeValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map attMap = attributeValue.m();
        for (Map.Entry entry : attMap.entrySet()) {
            AttributeValue attValue = (AttributeValue)entry.getValue();
            String key = (String)entry.getKey();
            Object value = DbUtils.getValueFromAttributeValue(attValue);
            map.put(key, value);
        }
        return map;
    }

    private static Object getValueFromAttributeValue(AttributeValue attValue) {
        Object value;
        if (attValue.hasM()) {
            value = DbUtils.convertAttributeValueToMap(attValue);
        } else if (attValue.hasL()) {
            value = DbUtils.convertAttributeValueToList(attValue);
        } else if (attValue.hasSs()) {
            value = attValue.ss();
        } else if (attValue.hasNs()) {
            value = attValue.ss();
        } else if (attValue.s() != null) {
            value = attValue.s();
        } else if (attValue.n() != null) {
            value = attValue.n();
        } else {
            throw new IllegalStateException("Unsupported type");
        }
        return value;
    }

    public static List<?> convertAttributeValueToList(AttributeValue attributeValue) {
        List attList = attributeValue.l();
        ArrayList<Object> list = new ArrayList<Object>();
        for (AttributeValue attValue : attList) {
            list.add(DbUtils.getValueFromAttributeValue(attValue));
        }
        return list;
    }
}

