/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeValueSerializer
extends JsonSerializer<AttributeValue> {
    public static final DefaultSdkAutoConstructMap<?, ?> EMPTY_ATTR_MAP = DefaultSdkAutoConstructMap.getInstance();
    public static final DefaultSdkAutoConstructList<?> EMPTY_ATTR_LIST = DefaultSdkAutoConstructList.getInstance();
    public static final JsonSerializer<AttributeValue> INSTANCE = new AttributeValueSerializer();

    public void serialize(AttributeValue av, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (av == null) {
            gen.writeNull();
        } else if (av.m() != EMPTY_ATTR_MAP) {
            gen.writeStartObject();
            Map map = av.m();
            for (Map.Entry entry : map.entrySet()) {
                gen.writeFieldName((String)entry.getKey());
                this.serialize((AttributeValue)entry.getValue(), gen, serializers);
            }
            gen.writeEndObject();
        } else if (av.l() != EMPTY_ATTR_LIST) {
            List list = av.l();
            gen.writeStartArray();
            for (AttributeValue a : list) {
                this.serialize(a, gen, serializers);
            }
            gen.writeEndArray();
        } else if (av.s() != null) {
            gen.writeString(av.s());
        } else if (av.n() != null) {
            gen.writeNumber(new BigDecimal(av.n()));
        } else if (av.bool() != null) {
            gen.writeBoolean(av.bool().booleanValue());
        } else if (av.nul() != null && av.nul().booleanValue()) {
            gen.writeNull();
        } else if (av.b() != null) {
            gen.writeBinary(av.b().asByteArray());
        } else if (av.ss() != EMPTY_ATTR_LIST) {
            List list = av.ss();
            int size = list.size();
            gen.writeStartArray(size);
            for (String s : list) {
                gen.writeString(s);
            }
            gen.writeEndArray();
        } else if (av.bs() != EMPTY_ATTR_LIST) {
            List list = av.bs();
            int size = list.size();
            gen.writeStartArray(size);
            for (SdkBytes sdkBytes : list) {
                gen.writeBinary(sdkBytes.asByteArray());
            }
            gen.writeEndArray();
        } else if (av.ns() != EMPTY_ATTR_LIST) {
            List list = av.ns();
            int size = list.size();
            gen.writeStartArray(size);
            for (String s : list) {
                gen.writeNumber(new BigDecimal(s));
            }
            gen.writeEndArray();
        } else if (av.nul() != null) {
            gen.writeNull();
        }
    }
}

