/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.repositories;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.leo.aws.ddb.annotations.KeyType;
import org.leo.aws.ddb.data.Page;
import org.leo.aws.ddb.data.PatchUpdate;
import org.leo.aws.ddb.data.PrimaryKey;
import org.leo.aws.ddb.data.UpdateItem;
import org.leo.aws.ddb.exceptions.DbException;
import org.leo.aws.ddb.repositories.BaseRepositoryUtils;
import org.leo.aws.ddb.repositories.DataMapper;
import org.leo.aws.ddb.repositories.DataMapperUtils;
import org.leo.aws.ddb.utils.ApplicationContextUtils;
import org.leo.aws.ddb.utils.Expr;
import org.leo.aws.ddb.utils.Tuple;
import org.leo.aws.ddb.utils.Tuple4;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.functions.Action2;
import rx.functions.Func1;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public interface DynamoDbRepository<ENTITY_TYPE> {
    public static final int DEFAULT_PAGE_SIZE = 20;

    default public DynamoDbAsyncClient dynamoDbClient() {
        return DataMapperUtils.getDynamoDbAsyncClient();
    }

    default public String getRangeKeyName() {
        return (String)DataMapperUtils.getDataMapper(this.getParameterType()).getPKMapping().get(KeyType.RANGE_KEY)._1();
    }

    default public Class<ENTITY_TYPE> getParameterType() {
        return BaseRepositoryUtils.getInstance().getRepoParameterType(this);
    }

    default public PrimaryKey getPrimaryKey(ENTITY_TYPE item) {
        return DataMapperUtils.getDataMapper(this.getParameterType()).createPKFromItem(item);
    }

    default public String getHashKeyName() {
        Class<ENTITY_TYPE> type = this.getParameterType();
        DataMapper<ENTITY_TYPE> dataMapper = DataMapperUtils.getDataMapper(this.getParameterType());
        if (dataMapper == null) {
            throw new DbException(MessageFormat.format("Could not find any entity of type [{0}] in the provided entityBasePackage [service.aws.ddb.entityBasePackage: {1}]", type.getName(), ApplicationContextUtils.getInstance().getEnvironment().getProperty("service.aws.ddb.entityBasePackage")));
        }
        return (String)dataMapper.getPKMapping().get(KeyType.HASH_KEY)._1();
    }

    default public Map<String, ?> getFieldMappings(ENTITY_TYPE item, boolean includeNullValues) {
        Class<ENTITY_TYPE> paramType = this.getParameterType();
        DataMapper<ENTITY_TYPE> dataMapper = DataMapperUtils.getDataMapper(paramType);
        PrimaryKey primaryKey = dataMapper.createPKFromItem(item);
        Stream<Tuple4> fieldMappings = dataMapper.getMappedValues(item).filter(a -> !((String)a._1()).equals(primaryKey.getHashKeyName())).filter(a -> !((String)a._1()).equals(primaryKey.getRangeKeyName()));
        return includeNullValues ? fieldMappings.collect(Collectors.toMap(Tuple4::_1, Tuple4::_2)) : fieldMappings.filter(c -> c._2() != null).collect(Collectors.toMap(Tuple4::_1, Tuple4::_2));
    }

    default public Flux<ENTITY_TYPE> findByHashKey(Object hashKeyValue) {
        return this.findByHashKey(this.getHashKeyName(), hashKeyValue, null, null);
    }

    default public Flux<ENTITY_TYPE> findByHashKey(String hashKeyName, Object hashKeyValue) {
        return this.findByHashKey(hashKeyName, hashKeyValue, null, null);
    }

    default public Flux<ENTITY_TYPE> findByHashKey(String hashKeyName, Object hashKeyValue, @Nullable Page page) {
        return this.findByHashKey(hashKeyName, hashKeyValue, page, null, null);
    }

    default public Flux<ENTITY_TYPE> findByHashKey(String hashKeyName, Object hashKeyValueObj, @Nullable Expr expr) {
        return this.findByHashKey(hashKeyName, hashKeyValueObj, null, expr);
    }

    default public Flux<ENTITY_TYPE> findByHashKey(String hashKeyName, Object hashKeyValueObj, @Nullable String indexName, @Nullable Expr expr) {
        return this.findByHashKey(hashKeyName, hashKeyValueObj, null, indexName, expr);
    }

    default public Flux<ENTITY_TYPE> findByHashKey(String hashKeyName, Object hashKeyValueObj, @Nullable Page page, @Nullable String indexName, @Nullable Expr expr) {
        return this.findByHashKeyAndRangeKeyStartsWith(hashKeyName, hashKeyValueObj, null, null, page, indexName, expr);
    }

    default public Flux<ENTITY_TYPE> findByHashKeyAndRangeKeyStartsWith(String hashKey, Object hashKeyValueObj, String rangeKey, String rangeKeyValue) {
        return this.findByHashKeyAndRangeKeyStartsWith(hashKey, hashKeyValueObj, rangeKey, rangeKeyValue, null);
    }

    default public Flux<ENTITY_TYPE> findByHashKeyAndRangeKeyStartsWith(String hashKey, Object hashKeyValueObj, String rangeKey, String rangeKeyValue, @Nullable Page page) {
        return this.findByHashKeyAndRangeKeyStartsWith(hashKey, hashKeyValueObj, rangeKey, rangeKeyValue, page, null, null);
    }

    default public Flux<ENTITY_TYPE> findByHashKeyAndRangeKeyStartsWith(String hashKey, Object hashKeyValueObj, String rangeKey, String rangeKeyValue, @Nullable String indexName, @Nullable Expr expr) {
        return this.findByHashKeyAndRangeKeyStartsWithPagination(hashKey, hashKeyValueObj, rangeKey, rangeKeyValue, null, indexName, expr);
    }

    default public Flux<ENTITY_TYPE> findByHashKeyAndRangeKeyStartsWith(String hashKey, Object hashKeyValueObj, String rangeKey, String rangeKeyValue, @Nullable Page page, @Nullable String indexName, @Nullable Expr expr) {
        return this.findByHashKeyAndRangeKeyStartsWithPagination(hashKey, hashKeyValueObj, rangeKey, rangeKeyValue, page, indexName, expr);
    }

    default public Flux<ENTITY_TYPE> findByHashKeyAndRangeKeyStartsWithPagination(String hashKey, Object hashKeyValueObj, String rangeKey, String rangeKeyValue, @Nullable Page page) {
        return this.findByHashKeyAndRangeKeyStartsWithPagination(hashKey, hashKeyValueObj, rangeKey, rangeKeyValue, page, null, null);
    }

    default public Flux<ENTITY_TYPE> findByHashKeyAndRangeKeyStartsWithPagination(String hashKey, Object hashKeyValueObj, String rangeKey, String rangeKeyValue, @Nullable Page page, @Nullable String indexName, @Nullable Expr expr) {
        return BaseRepositoryUtils.getInstance().findByHashKeyAndRangeKeyStartsWithPagination(hashKey, hashKeyValueObj, rangeKey, rangeKeyValue, page, indexName, this.getParameterType(), expr);
    }

    default public Flux<ENTITY_TYPE> findBySecondaryIndex(String indexName, Object hashKeyValueObj) {
        return this.findBySecondaryIndex(indexName, hashKeyValueObj, null);
    }

    default public Flux<ENTITY_TYPE> findBySecondaryIndex(@NonNull String indexName, Object hashKeyValueObj, Object rangeKeyValue) {
        return this.findBySecondaryIndex(indexName, hashKeyValueObj, rangeKeyValue, null);
    }

    default public Flux<ENTITY_TYPE> findBySecondaryIndex(@NonNull String indexName, Object hashKeyValueObj, @Nullable Expr expr) {
        return this.findBySecondaryIndex(indexName, hashKeyValueObj, null, expr);
    }

    default public Flux<ENTITY_TYPE> findBySecondaryIndex(@NonNull String indexName, Object hashKeyValueObj, Object rangeKeyValue, @Nullable Expr expr) {
        return BaseRepositoryUtils.getInstance().findByGlobalSecondaryIndex(indexName, hashKeyValueObj, rangeKeyValue, this::getPrimaryKey, this::getParameterType, pks -> BaseRepositoryUtils.getInstance().findByPrimaryKeys((List<PrimaryKey>)pks, this::getParameterType), expr);
    }

    default public Mono<ENTITY_TYPE> findOne(PrimaryKey primaryKey) {
        return this.findByPrimaryKey(primaryKey);
    }

    default public Flux<ENTITY_TYPE> findAll() {
        return this.findAll(20);
    }

    default public Flux<ENTITY_TYPE> findAll(int limit) {
        return BaseRepositoryUtils.getInstance().findAll(limit, this::getParameterType);
    }

    default public Flux<ENTITY_TYPE> findAll(@Nullable Expr expr) {
        return this.findAll(expr, 20);
    }

    default public Flux<ENTITY_TYPE> findAll(@Nullable Expr expr, int limit) {
        return BaseRepositoryUtils.getInstance().findAll(expr, limit, this::getParameterType);
    }

    default public Mono<ENTITY_TYPE> findByPrimaryKey(@NonNull PrimaryKey primaryKey) {
        return BaseRepositoryUtils.getInstance().findByPrimaryKey(primaryKey, this::getParameterType);
    }

    default public Mono<ENTITY_TYPE> findByPrimaryKey(Object hashKeyValue) {
        String rangeKeyName;
        String hashKeyName = this.getHashKeyName();
        Tuple<String, Field> rangeKey = DataMapperUtils.getDataMapper(this.getParameterType()).getPKMapping().get(KeyType.RANGE_KEY);
        String string = rangeKeyName = rangeKey == null ? null : (String)rangeKey._1();
        if (!StringUtils.isEmpty((Object)rangeKeyName)) {
            throw new DbException("This method cannot be used for entities that has a range key");
        }
        return this.findByPrimaryKey(PrimaryKey.builder().hashKeyName(hashKeyName).hashKeyValue(hashKeyValue).build());
    }

    default public Mono<ENTITY_TYPE> findByPrimaryKey(Object hashKeyValue, Object rangeKeyValue) {
        String hashKeyName = this.getHashKeyName();
        String rangeKeyName = this.getRangeKeyName();
        if (StringUtils.isEmpty((Object)rangeKeyName)) {
            throw new DbException("This method cannot be used for entities that does not have a range key");
        }
        return this.findByPrimaryKey(PrimaryKey.builder().hashKeyName(hashKeyName).hashKeyValue(hashKeyValue).rangeKeyName(rangeKeyName).rangeKeyValue(rangeKeyValue).build());
    }

    default public Flux<ENTITY_TYPE> findBy(PrimaryKey ... primaryKeys) {
        return this.findByPrimaryKeys(Arrays.asList(primaryKeys));
    }

    default public Flux<ENTITY_TYPE> findByPrimaryKeys(@NonNull List<PrimaryKey> primaryKeys) {
        return BaseRepositoryUtils.getInstance().findByPrimaryKeys(primaryKeys, this::getParameterType);
    }

    default public Mono<ENTITY_TYPE> putItem(@NonNull ENTITY_TYPE item) {
        DataMapperUtils.getDataMapper(this.getParameterType());
        Action2 ttlAction = (a, b) -> {};
        return this.putItem(item, ttlAction);
    }

    default public Mono<ENTITY_TYPE> putItem(@NonNull ENTITY_TYPE item, Action2<ENTITY_TYPE, Map<String, AttributeValue>> ttlAction) {
        return Mono.defer(() -> Mono.fromFuture(BaseRepositoryUtils.getInstance().saveItem(item, true, ttlAction, DataMapperUtils.getDataMapper(this.getParameterType()))));
    }

    default public Flux<ENTITY_TYPE> putItem(@NonNull List<ENTITY_TYPE> items) {
        return BaseRepositoryUtils.getInstance().batchWriteRequest(dataMapper -> items.stream().map(item -> (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(dataMapper.mapFromEntityToAttributeValue(item)).build()).build()), () -> items, DataMapperUtils.getDataMapper(this.getParameterType()));
    }

    default public Mono<ENTITY_TYPE> updateItem(@NonNull ENTITY_TYPE item) {
        return BaseRepositoryUtils.getInstance().updateItem(item, this::getPrimaryKey, this::getParameterType);
    }

    default public Mono<ENTITY_TYPE> updateItem(@NonNull PrimaryKey primaryKey, @NonNull Map<String, Object> updatedValues) {
        return BaseRepositoryUtils.getInstance().updateItem(primaryKey, updatedValues, pk -> BaseRepositoryUtils.getInstance().findByPrimaryKey((PrimaryKey)pk, this::getParameterType), this::getParameterType);
    }

    default public Mono<ENTITY_TYPE> updateItem(@NonNull UpdateItem updateItem) {
        return this.updateItem(updateItem.getPrimaryKey(), updateItem.getUpdatedValues());
    }

    default public Flux<ENTITY_TYPE> updateItem(@NonNull List<UpdateItem> updateItems) {
        return BaseRepositoryUtils.getInstance().updateItem(updateItems, this::getParameterType, pks -> BaseRepositoryUtils.getInstance().findByPrimaryKeys((List<PrimaryKey>)pks, this::getParameterType));
    }

    default public Flux<ENTITY_TYPE> updateItems(String keyValue, @NonNull List<? extends PatchUpdate> patchUpdates, Func1<PatchUpdate, UpdateItem> convertFunc) {
        return this.updateItem(patchUpdates.stream().map(arg_0 -> convertFunc.call(arg_0)).collect(Collectors.toList()));
    }

    default public Flux<ENTITY_TYPE> deleteAllItems(@NonNull List<ENTITY_TYPE> items) {
        return BaseRepositoryUtils.getInstance().batchWriteRequest(dataMapper -> items.stream().map(item -> (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(dataMapper.getPrimaryKey(dataMapper.createPKFromItem(item))).build()).build()), () -> items, DataMapperUtils.getDataMapper(this.getParameterType()));
    }

    default public Flux<ENTITY_TYPE> batchWrite(List<ENTITY_TYPE> putItems, List<ENTITY_TYPE> deleteItems) {
        return BaseRepositoryUtils.getInstance().batchWrite(putItems, deleteItems, this::getParameterType);
    }

    default public Mono<ENTITY_TYPE> deleteItem(@NonNull ENTITY_TYPE item) {
        return BaseRepositoryUtils.getInstance().deleteItem(item, this::getParameterType);
    }

    default public Flux<ENTITY_TYPE> saveItems(@NonNull List<ENTITY_TYPE> item) {
        return this.batchWrite(item, Collections.emptyList());
    }

    default public Mono<ENTITY_TYPE> saveItem(@NonNull ENTITY_TYPE item) {
        DataMapperUtils.getDataMapper(this.getParameterType());
        return this.saveItem(item, (entity, attributeValueMap) -> {});
    }

    default public Mono<ENTITY_TYPE> saveItem(ENTITY_TYPE item, Action2<ENTITY_TYPE, Map<String, AttributeValue>> ttlAction) {
        return Mono.defer(() -> Mono.fromFuture(BaseRepositoryUtils.getInstance().saveItem(item, false, ttlAction, DataMapperUtils.getDataMapper(this.getParameterType()))));
    }
}

