/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.repositories;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import org.leo.aws.ddb.annotations.KeyType;
import org.leo.aws.ddb.repositories.AttributeMapper;
import org.leo.aws.ddb.repositories.DataMapper;
import org.leo.aws.ddb.repositories.MapperUtils;
import org.leo.aws.ddb.utils.Tuple;

abstract class AbstractDataMapper<T>
implements DataMapper<T> {
    AbstractDataMapper() {
    }

    @Override
    public Class<T> getParameterType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    protected String getHashKey() {
        KeyType keyType = KeyType.HASH_KEY;
        return this.getPKKey(keyType);
    }

    protected String getRangeKey() {
        KeyType keyType = KeyType.RANGE_KEY;
        return this.getPKKey(keyType);
    }

    private String getPKKey(KeyType keyType) {
        AttributeMapper<?> fieldMapping = MapperUtils.INSTANCE.getAttributeMappingMap().get(this.getParameterType().getName());
        Map<KeyType, Tuple<String, Field>> pkMapping = fieldMapping.getPrimaryKeyMapping();
        return ((Field)pkMapping.get(keyType)._2()).getName();
    }
}

