/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.data;

import org.leo.aws.ddb.data.PrimaryKey;

public class Page {
    private final int pageSize;
    private final PrimaryKey lastEndKey;

    private Page(int pageSize, PrimaryKey lastEndKey) {
        this.pageSize = pageSize;
        this.lastEndKey = lastEndKey;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PrimaryKey getLastEndKey() {
        return this.lastEndKey;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static interface Builder {
        public Builder pageSize(int var1);

        public Builder lastEndKey(PrimaryKey var1);

        public Page build();
    }

    private static class BuilderImpl
    implements Builder {
        private int pageSize = 10;
        private PrimaryKey lastEndKey;

        private BuilderImpl() {
        }

        @Override
        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder lastEndKey(PrimaryKey lastEndKey) {
            this.lastEndKey = lastEndKey;
            return this;
        }

        @Override
        public Page build() {
            return new Page(this.pageSize, this.lastEndKey);
        }
    }
}

