/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.repositories;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.leo.aws.ddb.annotations.DDBTable;
import org.leo.aws.ddb.annotations.DateCreated;
import org.leo.aws.ddb.annotations.DateUpdated;
import org.leo.aws.ddb.annotations.DbAttribute;
import org.leo.aws.ddb.annotations.HashKey;
import org.leo.aws.ddb.annotations.KeyType;
import org.leo.aws.ddb.annotations.RangeKey;
import org.leo.aws.ddb.annotations.SecondaryIndex;
import org.leo.aws.ddb.annotations.SecondaryIndices;
import org.leo.aws.ddb.annotations.Transient;
import org.leo.aws.ddb.annotations.VersionAttribute;
import org.leo.aws.ddb.data.VersionedEntity;
import org.leo.aws.ddb.exceptions.DbException;
import org.leo.aws.ddb.repositories.AttributeMapper;
import org.leo.aws.ddb.repositories.DataMapper;
import org.leo.aws.ddb.repositories.DataMapperUtils;
import org.leo.aws.ddb.repositories.GSI;
import org.leo.aws.ddb.utils.PropertyResolverUtils;
import org.leo.aws.ddb.utils.Tuple;
import org.leo.aws.ddb.utils.Tuple3;
import org.leo.aws.ddb.utils.Tuple4;
import org.leo.aws.ddb.utils.Tuples;
import org.leo.aws.ddb.utils.Utils;
import org.leo.aws.ddb.utils.exceptions.Issue;
import org.leo.aws.ddb.utils.exceptions.UtilsException;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public enum MapperUtils {
    INSTANCE;

    private final ConcurrentHashMap<String, AttributeMapper<?>> attributeMappingMap = new ConcurrentHashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private <T> List<Field> getAllFields(Class<T> dataClass) {
        return this.getAllFields(dataClass, (List<Field>)ImmutableList.of());
    }

    private List<Field> getAllFields(Class dataClass, List<Field> acc) {
        if (dataClass != VersionedEntity.class && dataClass != Object.class) {
            Field[] fields = dataClass.getDeclaredFields();
            return this.getAllFields(dataClass.getSuperclass(), (List<Field>)ImmutableList.builder().addAll(acc).addAll(fields != null && fields.length > 0 ? Arrays.asList(fields) : Collections.emptyList()).build());
        }
        if (dataClass == VersionedEntity.class) {
            return this.filterFields((List<Field>)ImmutableList.builder().addAll(acc).add((Object)ReflectionUtils.findField(VersionedEntity.class, (String)"version")).build());
        }
        return this.filterFields(acc);
    }

    private List<Field> filterFields(List<Field> fields) {
        return fields.stream().filter(field -> !field.getName().contains("ajc$")).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers())).collect(Collectors.toList());
    }

    <T> void setDbAttributes(Class<T> dataClass, Environment environment, DataMapper<T> dataMapper) {
        Utils.executeUsingLock((Lock)this.lock.writeLock(), () -> {
            Constructor constructor = this.constructor(dataClass);
            DDBTable table = dataClass.getAnnotation(DDBTable.class);
            List<Field> fields = this.getAllFields(dataClass);
            HashMap<String, Tuple<Field, DbAttribute>> map = new HashMap<String, Tuple<Field, DbAttribute>>();
            HashMap<KeyType, Tuple<String, Field>> primaryKeyMapping = new HashMap<KeyType, Tuple<String, Field>>();
            HashMap versionAttMap = new HashMap();
            ConcurrentHashMap indexMap = new ConcurrentHashMap();
            String tableName = table != null ? PropertyResolverUtils.getEnvironmentProperty((String)table.name(), (Environment)environment) : dataMapper.tableName();
            AttributeMapper.Builder builder = AttributeMapper.builder();
            fields.forEach(field -> this.setFieldMappings((Map<String, Tuple<Field, DbAttribute>>)map, (Map<KeyType, Tuple<String, Field>>)primaryKeyMapping, (Field)field, indexMap, versionAttMap, builder));
            if (!CollectionUtils.isEmpty(versionAttMap) && versionAttMap.size() > 1) {
                throw new DbException("Entity cannot have more than one version attribute");
            }
            if (CollectionUtils.isEmpty(primaryKeyMapping) || primaryKeyMapping.get(KeyType.HASH_KEY) == null) {
                throw new DbException(String.format("Entity class %s does not have a hash key defined", dataClass.getName()));
            }
            this.attributeMappingMap.put(dataClass.getName(), builder.mappedClass(dataClass).mappedFields(map).constructor(constructor).primaryKeyMapping(primaryKeyMapping).globalSecondaryIndexMap(indexMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, b -> ((GSI.Builder)b.getValue()).build()))).versionAttributeField(!CollectionUtils.isEmpty(versionAttMap) ? (Tuple)versionAttMap.entrySet().iterator().next().getValue() : null).tableName(tableName).build());
        });
    }

    <T> Stream<Tuple4<String, Object, Field, DbAttribute>> getMappedValues(T input, String parameterType) {
        AttributeMapper<?> fieldMapping = this.attributeMappingMap.get(parameterType);
        Map<String, Tuple<Field, DbAttribute>> fieldMap = fieldMapping.getMappedFields();
        Map<KeyType, Tuple<String, Field>> pkMapping = fieldMapping.getPrimaryKeyMapping();
        Set pkFields = pkMapping.values().stream().map(Tuple::_1).collect(Collectors.toSet());
        return fieldMap.entrySet().stream().map(entry -> Tuples.of((Object)((String)entry.getKey()), (Object)((Tuple)entry.getValue()))).map(a -> Tuples.of((Object)((String)a._1()), (Object)ReflectionUtils.getField((Field)((Field)((Tuple)a._2())._1()), (Object)input), (Object)((Field)((Tuple)a._2())._1()), (Object)((DbAttribute)((Tuple)a._2())._2()))).filter(a -> !pkFields.contains(a._1()));
    }

    <T> Stream<Tuple4<String, Object, Field, DbAttribute>> getMappedValues(T input, Class<T> parameterClass) {
        DataMapper<T> dataMapper = DataMapperUtils.getDataMapper(parameterClass);
        return dataMapper.getMappedValues(input);
    }

    <T> Stream<Tuple3<String, Field, DbAttribute>> getMappedValues(String parameterType) {
        AttributeMapper<?> fieldMapping = this.attributeMappingMap.get(parameterType);
        Map<String, Tuple<Field, DbAttribute>> fieldMap = fieldMapping.getMappedFields();
        Map<KeyType, Tuple<String, Field>> pkMapping = fieldMapping.getPrimaryKeyMapping();
        Set pkFields = pkMapping.values().stream().map(Tuple::_1).collect(Collectors.toSet());
        return fieldMap.entrySet().stream().map(entry -> Tuples.of((Object)((String)entry.getKey()), (Object)((Tuple)entry.getValue()))).map(a -> Tuples.of((Object)((String)a._1()), (Object)((Field)((Tuple)a._2())._1()), (Object)((DbAttribute)((Tuple)a._2())._2()))).filter(a -> !pkFields.contains(a._1()));
    }

    private <T> Constructor<T> constructor(Class<T> dataClass) {
        try {
            Constructor<T> constructor = dataClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new UtilsException(Issue.UNKNOWN_ERROR, "No empty constructor found for " + dataClass.getName(), (Throwable)e);
        }
    }

    private <T> void setFieldMappings(Map<String, Tuple<Field, DbAttribute>> mappedFields, Map<KeyType, Tuple<String, Field>> primaryKeyMapping, Field field, ConcurrentHashMap<String, GSI.Builder> IndexMap, Map<String, Tuple<Field, DbAttribute>> versionAttMap, AttributeMapper.Builder<T> builder) {
        field.setAccessible(true);
        List<Annotation> annotations = Arrays.stream(field.getAnnotations()).filter(a -> a instanceof DbAttribute || a instanceof Transient || a instanceof HashKey || a instanceof RangeKey || a instanceof SecondaryIndex || a instanceof SecondaryIndices || a instanceof DateUpdated || a instanceof DateCreated || a instanceof VersionAttribute).collect(Collectors.toList());
        if (!this.isTransient(annotations)) {
            if (this.isAnnotatedCorrectly(annotations)) {
                List<SecondaryIndex> gsiList;
                DbAttribute DbAttribute2 = !CollectionUtils.isEmpty(annotations) ? (DbAttribute)annotations.stream().filter(a -> a instanceof DbAttribute).findAny().orElse(null) : null;
                DateCreated dateCreated = !CollectionUtils.isEmpty(annotations) ? (DateCreated)annotations.stream().filter(a -> a instanceof DateCreated).findAny().orElse(null) : null;
                DateUpdated dateUpdated = !CollectionUtils.isEmpty(annotations) ? (DateUpdated)annotations.stream().filter(a -> a instanceof DateUpdated).findAny().orElse(null) : null;
                HashKey hashKey = !CollectionUtils.isEmpty(annotations) ? (HashKey)annotations.stream().filter(a -> a instanceof HashKey).findAny().orElse(null) : null;
                RangeKey rangeKey = !CollectionUtils.isEmpty(annotations) ? (RangeKey)annotations.stream().filter(a -> a instanceof RangeKey).findAny().orElse(null) : null;
                SecondaryIndex gsiElement = !CollectionUtils.isEmpty(annotations) ? (SecondaryIndex)annotations.stream().filter(a -> a instanceof SecondaryIndex).findAny().orElse(null) : null;
                SecondaryIndices gsis = !CollectionUtils.isEmpty(annotations) ? (SecondaryIndices)annotations.stream().filter(a -> a instanceof SecondaryIndices).findAny().orElse(null) : null;
                VersionAttribute versionAttribute = !CollectionUtils.isEmpty(annotations) ? (VersionAttribute)annotations.stream().filter(a -> a instanceof VersionAttribute).findAny().orElse(null) : null;
                String fieldName = DbAttribute2 != null ? DbAttribute2.value() : field.getName();
                Class<?> fieldClass = field.getType();
                if (versionAttribute != null && fieldClass != Integer.TYPE && fieldClass != Integer.class && fieldClass != Long.class && fieldClass != Long.TYPE) {
                    throw new DbException("VersionedAttribute field can only be of type integer or long");
                }
                if (gsis != null && gsiElement != null) {
                    throw new DbException(MessageFormat.format("Both GSIs and GSI cannot be used for the same field [{0}.{1}]", field.getDeclaringClass(), field.getName()));
                }
                List<SecondaryIndex> list = gsiList = gsis != null ? Arrays.asList(gsis.indices()) : Collections.singletonList(gsiElement);
                if (hashKey != null) {
                    primaryKeyMapping.put(KeyType.HASH_KEY, (Tuple<String, Field>)Tuples.of((Object)fieldName, (Object)field));
                } else if (rangeKey != null) {
                    primaryKeyMapping.put(KeyType.RANGE_KEY, (Tuple<String, Field>)Tuples.of((Object)fieldName, (Object)field));
                }
                gsiList.forEach(gsi -> {
                    if (gsi != null) {
                        GSI.Builder gsiBuilder = IndexMap.computeIfAbsent(gsi.name(), s -> GSI.builder(gsi.name()).projectionType(gsi.projectionType()));
                        Tuple keyTuple = Tuples.of((Object)fieldName, (Object)field);
                        switch (gsi.type()) {
                            case HASH_KEY: {
                                gsiBuilder.hashKeyTuple((Tuple<String, Field>)keyTuple);
                                break;
                            }
                            case RANGE_KEY: {
                                gsiBuilder.rangeKeyTuple((Tuple<String, Field>)keyTuple);
                                break;
                            }
                            default: {
                                throw new DbException("Unrecognized key type");
                            }
                        }
                    }
                });
                String fieldNameVal = this.getFieldName(DbAttribute2, dateCreated, dateUpdated, field, builder);
                mappedFields.put(fieldNameVal, (Tuple<Field, DbAttribute>)Tuples.of((Object)field, (Object)DbAttribute2));
                if (versionAttribute != null) {
                    versionAttMap.put(fieldNameVal, (Tuple<Field, DbAttribute>)Tuples.of((Object)field, (Object)DbAttribute2));
                }
            } else {
                throw new UtilsException(Issue.INCORRECT_MODEL_ANNOTATION, "A field can only have one of the following annotation: [DbAttribute, DateCreated, DateUpdated]");
            }
        }
    }

    private <T> String getFieldName(DbAttribute DbAttribute2, DateCreated dateCreated, DateUpdated dateUpdated, Field field, AttributeMapper.Builder<T> builder) {
        String fieldName;
        if (DbAttribute2 != null) {
            fieldName = DbAttribute2.value();
        } else if (dateCreated != null) {
            fieldName = dateCreated.value();
            builder.dateCreatedField((Tuple<String, Field>)Tuples.of((Object)dateCreated.value(), (Object)field));
        } else if (dateUpdated != null) {
            fieldName = dateUpdated.value();
            builder.dateUpdatedField((Tuple<String, Field>)Tuples.of((Object)dateUpdated.value(), (Object)field));
        } else {
            fieldName = field.getName();
        }
        return fieldName;
    }

    private boolean isTransient(List<Annotation> annotations) {
        return !CollectionUtils.isEmpty(annotations) && annotations.stream().anyMatch(a -> a instanceof Transient);
    }

    private boolean isAnnotatedCorrectly(List<Annotation> annotations) {
        List annotationList;
        List list = annotationList = CollectionUtils.isEmpty(annotations) ? annotations.stream().filter(a -> a instanceof DbAttribute || a instanceof DateCreated || a instanceof DateUpdated).collect(Collectors.toList()) : Collections.emptyList();
        return CollectionUtils.isEmpty(annotationList) || annotationList.size() == 1;
    }

    public ConcurrentHashMap<String, AttributeMapper<?>> getAttributeMappingMap() {
        return this.attributeMappingMap;
    }

    static MapperUtils getInstance() {
        return INSTANCE;
    }
}

