/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.data;

import java.util.Map;
import org.leo.aws.ddb.data.PrimaryKey;

public abstract class UpdateItem {
    private final PrimaryKey primaryKey;
    private final Map<String, Object> updatedValues;

    protected UpdateItem(PrimaryKey primaryKey, Map<String, Object> updatedValues) {
        this.primaryKey = primaryKey;
        this.updatedValues = updatedValues;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getUpdatedValues() {
        return this.updatedValues;
    }

    public static Builder defaultBuilder() {
        return DefaultUpdateItem.builder();
    }

    public static interface Builder {
        public Builder primaryKey(PrimaryKey var1);

        public Builder updatedValues(Map<String, Object> var1);

        public UpdateItem build();
    }

    private static final class DefaultUpdateItem
    extends UpdateItem {
        private DefaultUpdateItem(PrimaryKey primaryKey, Map<String, Object> updatedValues) {
            super(primaryKey, updatedValues);
        }

        private static Builder builder() {
            return new BuilderImpl();
        }

        private static final class BuilderImpl
        implements Builder {
            private PrimaryKey primaryKey;
            private Map<String, Object> updatedValues;

            private BuilderImpl() {
            }

            @Override
            public Builder primaryKey(PrimaryKey primaryKey) {
                this.primaryKey = primaryKey;
                return this;
            }

            @Override
            public Builder updatedValues(Map<String, Object> updatedValues) {
                this.updatedValues = updatedValues;
                return this;
            }

            @Override
            public UpdateItem build() {
                return new DefaultUpdateItem(this.primaryKey, this.updatedValues);
            }
        }
    }
}

