/*
 * Decompiled with CFR 0.152.
 */
package org.leo.aws.ddb.repositories;

import java.util.Map;
import org.leo.aws.ddb.autoconfigure.AwsEnvironmentProperties;
import org.leo.aws.ddb.autoconfigure.DynamoDbProperties;
import org.leo.aws.ddb.config.EntityValidationConfig;
import org.leo.aws.ddb.repositories.DataMapper;
import org.leo.aws.ddb.repositories.DataMapperConfig;
import org.leo.aws.ddb.repositories.DataMapperConfigCleanUp;
import org.leo.aws.ddb.repositories.DynamoDbRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;

@Configuration
@ConditionalOnClass(value={DynamoDbRepository.class})
@EnableConfigurationProperties(value={AwsEnvironmentProperties.class, DynamoDbProperties.class})
@Import(value={DataMapperConfig.class})
public class DdbAutoConfiguration {
    @Value(value="${org.leo.aws.ddb.entities.basePackage:org.leo}")
    private String dtoBasePackage;

    @Bean
    @ConditionalOnProperty(prefix="org.leo.aws", value={"aws-access-key-secret", "aws-access-key"})
    public AwsCredentialsProvider staticCredentialsProvider(AwsEnvironmentProperties dynamoDbProperties) {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)dynamoDbProperties.getAwsAccessKey(), (String)dynamoDbProperties.getAwsAccessKeySecret()));
    }

    @Bean
    @ConditionalOnBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.leo.aws", value={"region"})
    public DynamoDbAsyncClient amazonDynamoDB(AwsCredentialsProvider staticCredentialsProvider, AwsEnvironmentProperties dynamoDbProperties) {
        return (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)dynamoDbProperties.getRegion()))).credentialsProvider(staticCredentialsProvider)).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"staticCredentialsProvider"})
    @ConditionalOnProperty(prefix="org.leo.aws", value={"region"})
    public DynamoDbAsyncClient amazonDynamoDBEnv(AwsEnvironmentProperties dynamoDbProperties) {
        return (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().region(Region.of((String)dynamoDbProperties.getRegion()))).build();
    }

    @Bean(name={"entityValidationConfigMain"})
    @ConditionalOnProperty(prefix="org.leo.aws.ddb", value={"entity-base-package"})
    public EntityValidationConfig entityValidationConfigMain(DynamoDbProperties dynamoDbProperties) {
        return new EntityValidationConfig(dynamoDbProperties.getEntityBasePackage());
    }

    @Bean(name={"entityValidationConfigTmp"})
    @ConditionalOnMissingBean(name={"entityValidationConfigMain"})
    public EntityValidationConfig entityValidationConfigTmp() {
        return new EntityValidationConfig(this.dtoBasePackage);
    }

    @Bean(name={"dataMapperConfigCleanUpMain"})
    @ConditionalOnProperty(prefix="org.leo.aws.ddb", value={"entity-base-package"})
    public DataMapperConfigCleanUp dataMapperConfigCleanUpMain(DynamoDbProperties dynamoDbProperties, Map<Class, DataMapper> dataMapperMap, Environment environment) {
        return new DataMapperConfigCleanUp(dynamoDbProperties.getEntityBasePackage(), dataMapperMap, environment);
    }

    @Bean(name={"dataMapperConfigCleanUp"})
    @ConditionalOnMissingBean(name={"dataMapperConfigCleanUpMain", "entityValidationConfigMain"})
    public DataMapperConfigCleanUp dataMapperConfigCleanUpTmp(Map<Class, DataMapper> dataMapperMap, Environment environment) {
        return new DataMapperConfigCleanUp(this.dtoBasePackage, dataMapperMap, environment);
    }
}

