/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.velocity.maven.plugin.mojo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import net.leadware.velocity.maven.plugin.mojo.LogHandler;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="velocity", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES, threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class VelocityMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(required=false, defaultValue="")
    private String encoding;
    @Parameter(required=true)
    private File outputDirectory;
    @Parameter(required=true)
    private FileSet templateFiles;
    @Parameter(required=true)
    private Properties templateValues;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Demarrage de la cible velocity....");
        Charset characterSet = null;
        if (this.encoding == null) {
            this.encoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
            if (this.encoding == null) {
                this.getLog().warn((CharSequence)"Utilisation de l'ensemble de caracteres par defaut");
                characterSet = Charset.defaultCharset();
            } else {
                characterSet = Charset.forName(this.encoding);
            }
        }
        this.getLog().debug((CharSequence)("Charset utilis\u00e9" + characterSet.displayName()));
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("runtime.log.logsystem", (Object)new LogHandler(this));
        Properties engineConfig = new Properties();
        engineConfig.setProperty("resource.loader", "classpath,file");
        engineConfig.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        engineConfig.setProperty("file.resource.loader.class", FileResourceLoader.class.getName());
        engineConfig.setProperty("file.resource.loader.path", this.project.getBasedir().getAbsolutePath());
        engine.init(engineConfig);
        VelocityContext context = new VelocityContext();
        context.put("project", (Object)this.project);
        context.put("system", (Object)System.getProperties());
        context.put("env", System.getenv());
        this.addPropertiesToContext(context, this.templateValues);
        try {
            List<?> fileNames = this.expandFileSet();
            if (fileNames == null || fileNames.isEmpty()) {
                this.getLog().warn((CharSequence)"Aucun fichier a traiter");
            } else {
                this.getLog().debug((CharSequence)"Traitement des fichiers");
                for (Object object : fileNames) {
                    String templateFile = (String)object;
                    this.getLog().debug((CharSequence)("Template -> " + templateFile));
                    this.translateFile(engine, this.templateFiles.getDirectory(), templateFile, context);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void addPropertiesToContext(VelocityContext context, Properties properties) {
        this.getLog().debug((CharSequence)("Importation des proprietes utilisateur dans le contexte" + properties));
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Enumeration<?> propEnumeration = properties.propertyNames();
        while (propEnumeration.hasMoreElements()) {
            String key = (String)propEnumeration.nextElement();
            String value = properties.getProperty(key, "").trim();
            this.getLog().debug((CharSequence)(key + "=" + value));
            if (context.containsKey((Object)key)) continue;
            context.put(key, (Object)value);
        }
    }

    private List<?> expandFileSet() throws IOException {
        File baseDir = new File(this.project.getBasedir().getAbsolutePath() + File.separator + this.templateFiles.getDirectory());
        this.getLog().debug((CharSequence)baseDir.getAbsolutePath());
        String includes = this.listToCsvString(this.templateFiles.getIncludes());
        this.getLog().debug((CharSequence)("Pattern Includes: " + includes));
        String excludes = this.listToCsvString(this.templateFiles.getExcludes());
        this.getLog().debug((CharSequence)("excludes: " + excludes));
        return FileUtils.getFileNames((File)baseDir, (String)includes, (String)excludes, (boolean)false);
    }

    private String listToCsvString(List<?> patterns) {
        String delim = "";
        StringBuffer buf = new StringBuffer();
        if (patterns != null) {
            for (Object object : patterns) {
                buf.append(delim).append(object);
                delim = ", ";
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateFile(VelocityEngine engine, String basedir, String templateFile, VelocityContext context) throws Exception {
        Template template = null;
        String inputFile = basedir + File.separator + templateFile;
        this.getLog().debug((CharSequence)("#translateFile - Fichier Input -> " + inputFile));
        try {
            template = engine.getTemplate(inputFile, this.encoding == null ? "UTF-8" : this.encoding);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Erreur de charement du template : " + inputFile));
            throw new MojoExecutionException("Erreur de charement du template : " + inputFile, e);
        }
        StringWriter sw = new StringWriter();
        try {
            template.merge((Context)context, (Writer)sw);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Erreur lors de la fusion du template et des variables" + inputFile + ":" + e.getMessage()));
            throw new MojoExecutionException("Erreur lors de la fusion du template et des variables" + inputFile, e);
        }
        File result = new File(this.outputDirectory.getAbsoluteFile() + File.separator + templateFile);
        File dir = result.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Echec lors de la creation du repertoire de dortie");
        }
        FileOutputStream os = new FileOutputStream(result);
        try {
            os.write(sw.toString().getBytes(this.encoding == null ? "UTF-8" : this.encoding));
        }
        finally {
            os.close();
        }
    }
}

