/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.velocity.maven.plugin.mojo;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;

public class LogHandler
implements LogChute {
    private AbstractMojo mojo;

    public LogHandler(AbstractMojo mojo) {
        this.mojo = mojo;
    }

    public boolean isLevelEnabled(int level) {
        boolean enabled = false;
        if (level == 0 && this.mojo.getLog().isDebugEnabled()) {
            enabled = true;
        } else if (level == 1 && this.mojo.getLog().isInfoEnabled()) {
            enabled = true;
        } else if (level == 2 && this.mojo.getLog().isWarnEnabled()) {
            enabled = true;
        } else if (level == 3 && this.mojo.getLog().isErrorEnabled()) {
            enabled = true;
        }
        return enabled;
    }

    public void log(int level, String content) {
        if (this.isLevelEnabled(level)) {
            switch (level) {
                case 0: {
                    this.mojo.getLog().debug((CharSequence)content);
                    break;
                }
                case 1: {
                    this.mojo.getLog().info((CharSequence)content);
                    break;
                }
                case 2: {
                    this.mojo.getLog().warn((CharSequence)content);
                    break;
                }
                case 3: {
                    this.mojo.getLog().error((CharSequence)content);
                    break;
                }
            }
        }
    }

    public void log(int level, String content, Throwable throwable) {
        if (this.isLevelEnabled(level)) {
            switch (level) {
                case 0: {
                    this.mojo.getLog().debug((CharSequence)content, throwable);
                    break;
                }
                case 1: {
                    this.mojo.getLog().info((CharSequence)content, throwable);
                    break;
                }
                case 2: {
                    this.mojo.getLog().warn((CharSequence)content, throwable);
                    break;
                }
                case 3: {
                    this.mojo.getLog().error((CharSequence)content, throwable);
                    break;
                }
            }
        }
    }

    public void init(RuntimeServices runtimeServices) throws Exception {
    }
}

