/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.messaging.jms.tools.hornetq.factory;

import java.util.HashMap;
import javax.jms.ConnectionFactory;
import net.leadware.messaging.jms.tools.factory.ConnectionFactoryClientBuilder;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;

public class HornetQNettyConnectionFactoryClientBuilder
implements ConnectionFactoryClientBuilder {
    private String jmsServerHost = "localhost";
    private String jmsServerPort = "5455";

    public String getJmsServerHost() {
        return this.jmsServerHost;
    }

    public void setJmsServerHost(String jmsServerHost) {
        this.jmsServerHost = jmsServerHost;
        if (jmsServerHost == null || jmsServerHost.trim().isEmpty()) {
            this.jmsServerHost = "localhost";
        }
    }

    public String getJmsServerPort() {
        return this.jmsServerPort;
    }

    public void setJmsServerPort(String jmsServerPort) {
        this.jmsServerPort = jmsServerPort;
        if (jmsServerPort == null || jmsServerPort.trim().isEmpty()) {
            this.jmsServerPort = "5455";
        }
    }

    public ConnectionFactory build() {
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        connectionParams.put("port", Integer.parseInt(this.jmsServerPort));
        connectionParams.put("host", this.jmsServerHost);
        TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams);
        ConnectionFactory connectionFactory = (ConnectionFactory)HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
        return connectionFactory;
    }
}

