/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.autoconfigure;

import io.swagger.annotations.ApiModelProperty;
import kafka.server.KafkaServer;
import kafka.zk.EmbeddedZookeeper;
import net.leadware.kafka.embedded.KafkaSimulator;
import net.leadware.kafka.embedded.properties.SimulatorProperties;
import net.leadware.kafka.embedded.utils.KafkaSimulatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.core.KafkaTemplate;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ConditionalOnClass(value={KafkaSimulator.class, KafkaSimulatorFactory.class, BeanValidatorPluginsConfiguration.class, ApiModelProperty.AccessMode.class, KafkaTemplate.class, KafkaAdmin.class, KafkaServer.class, EmbeddedZookeeper.class})
@EnableConfigurationProperties(value={SimulatorProperties.class})
@EnableSwagger2
@Import(value={BeanValidatorPluginsConfiguration.class})
@ComponentScan(basePackageClasses={KafkaSimulator.class})
public class KafkaEmbeddedAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KafkaEmbeddedAutoConfiguration.class);
    @Autowired
    private SimulatorProperties simulatorProperties;

    @ConditionalOnProperty(prefix="embedded.kafka.simulator", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @ConditionalOnMissingBean
    @Bean
    @Scope(value="singleton")
    public KafkaSimulatorFactory kafkaSimulatorFactory() {
        log.debug("Cr\u00e9ation du Bean de fabrique des Simulateurs Kafka");
        return new KafkaSimulatorFactory(this.simulatorProperties);
    }

    @ConditionalOnProperty(prefix="embedded.kafka.simulator", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @ConditionalOnMissingBean
    @Bean
    @Scope(value="singleton")
    public KafkaSimulator kafkaSimulator(KafkaSimulatorFactory kafkaSimulatorFactory) {
        log.debug("Cr\u00e9ation du Bean de simulation Kafka");
        return kafkaSimulatorFactory.getInstance();
    }

    @ConditionalOnProperty(prefix="embedded.kafka.simulator", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @Bean
    public Docket kafkaEmbeddedApi() {
        log.debug("Cr\u00e9ation du Bean swagger d'exposition de la documentation de l'API Kafka Embedded");
        return new Docket(DocumentationType.SWAGGER_2).groupName("KafkaEmbeddedApi").select().apis(RequestHandlerSelectors.basePackage((String)"net.leadware.kafka.embedded")).paths(PathSelectors.any()).build();
    }
}

