/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.utils.jsr303.file;

import java.lang.annotation.Annotation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.leadware.kafka.embedded.tools.SimulatorUtils;
import net.leadware.kafka.embedded.utils.jsr303.file.FileValidator;

public class FileValidatorEngine
implements ConstraintValidator<FileValidator, String> {
    private FileValidator fileValidator;

    public void initialize(FileValidator fileValidator) {
        super.initialize((Annotation)fileValidator);
        this.fileValidator = fileValidator;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.trim().isEmpty()) {
            return this.fileValidator.acceptOnEmptyField();
        }
        switch (this.fileValidator.visibility()) {
            case EXISTS: {
                switch (this.fileValidator.fileType()) {
                    case FILE: {
                        return SimulatorUtils.isFile(value.trim());
                    }
                    case DIRECTORY: {
                        return SimulatorUtils.isDirectory(value.trim());
                    }
                    case ANY: {
                        return SimulatorUtils.fileExists(value.trim());
                    }
                }
                return SimulatorUtils.fileExists(value.trim());
            }
            case NOTEXISTS: {
                switch (this.fileValidator.fileType()) {
                    case FILE: {
                        return !SimulatorUtils.isFile(value.trim());
                    }
                    case DIRECTORY: {
                        return !SimulatorUtils.isDirectory(value.trim());
                    }
                    case ANY: {
                        return !SimulatorUtils.fileExists(value.trim());
                    }
                }
                return !SimulatorUtils.fileExists(value.trim());
            }
            case HIDDEN: {
                return SimulatorUtils.isHidden(value.trim());
            }
            case READEABLE: {
                return SimulatorUtils.isReadeable(value.trim());
            }
            case WRITEABLE: {
                return SimulatorUtils.isWriteable(value.trim());
            }
        }
        return false;
    }
}

