/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SocketUtils;

public class SimulatorUtils {
    public static final int SIMULATOR_GENERATED_MIN_PORT = 1024;

    public static boolean isExecutable(String path) {
        try {
            return SimulatorUtils.getFile(path).canExecute();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWriteable(String path) {
        try {
            return SimulatorUtils.getFile(path).canWrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isReadeable(String path) {
        try {
            return SimulatorUtils.getFile(path).canRead();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isHidden(String path) {
        try {
            return SimulatorUtils.getFile(path).isHidden();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFile(String path) {
        try {
            return SimulatorUtils.getFile(path).isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDirectory(String path) {
        try {
            return SimulatorUtils.getFile(path).isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean fileExists(String path) {
        try {
            return SimulatorUtils.getFile(path) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static File getFile(String path) {
        try {
            return ResourceUtils.getFile((String)path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Le chemin n'existe pas : " + path);
        }
    }

    public static String getResolvedPath(String rawPath) {
        try {
            return ResourceUtils.getURL((String)rawPath).getFile();
        }
        catch (Exception e) {
            return rawPath;
        }
    }

    public static boolean isValidJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static int findAvailablePortExcept(int ... excludes) {
        if (excludes == null || excludes.length == 0) {
            return SocketUtils.findAvailableTcpPort((int)1024);
        }
        int generatedPortMinValue = Arrays.stream(excludes).sorted().max().getAsInt() + 1;
        if (generatedPortMinValue < 1024) {
            generatedPortMinValue = 1024;
        }
        return SocketUtils.findAvailableTcpPort((int)generatedPortMinValue);
    }
}

