/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.properties;

import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.Size;
import net.leadware.kafka.embedded.properties.BrokerProperties;
import net.leadware.kafka.embedded.properties.KeystoreProperties;
import net.leadware.kafka.embedded.properties.SslClientAuthentication;
import net.leadware.kafka.embedded.properties.SslProtocol;
import net.leadware.kafka.embedded.utils.jsr303.file.FileType;
import net.leadware.kafka.embedded.utils.jsr303.file.FileValidator;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="embedded.kafka.simulator")
public class SimulatorProperties {
    public static final String SIMULATOR_PROPERTIES_PREFIX = "embedded.kafka.simulator";
    @NotNull(message="Veuillez renseigner l'etat d'activation du simulateur KAFKA")
    private @NotNull(message="Veuillez renseigner l'etat d'activation du simulateur KAFKA") Boolean enabled = Boolean.TRUE;
    @FileValidator(fileType=FileType.DIRECTORY)
    private String javaTemporaryDirectory;
    @NotNull(message="Veuillez renseigner l'\u00e9tat de contr\u00f4le d'arr\u00eat des brokers")
    private @NotNull(message="Veuillez renseigner l'\u00e9tat de contr\u00f4le d'arr\u00eat des brokers") Boolean controlledShutdown = Boolean.TRUE;
    @NotNull(message="Veuillez renseigner l'etat d'activation de la suppression de topics du simulateur KAFKA")
    private @NotNull(message="Veuillez renseigner l'etat d'activation de la suppression de topics du simulateur KAFKA") Boolean enableDeleteTopics = Boolean.TRUE;
    @NotNull(message="Veuillez renseigner le nombre de partition par topics")
    @Positive(message="Le nombre de partition par topic doit \u00eatre une valeur sup\u00e9rieure \u00e0 0")
    private @NotNull(message="Veuillez renseigner le nombre de partition par topics") @Positive(message="Le nombre de partition par topic doit \u00eatre une valeur sup\u00e9rieure \u00e0 0") Integer partitionCount = 1;
    @NotNull(message="Veuillez renseigner le nombre de threads r\u00e9seaux")
    @Positive(message="Le nombre de threads r\u00e9seaux doit \u00eatre une valeur sup\u00e9rieure \u00e0 0")
    private @NotNull(message="Veuillez renseigner le nombre de threads r\u00e9seaux") @Positive(message="Le nombre de threads r\u00e9seaux doit \u00eatre une valeur sup\u00e9rieure \u00e0 0") Integer networkThreadCount = 1;
    @NotNull(message="Veuillez renseigner le nombre de threads d'I/O")
    @Positive(message="Le nombre de threads I/O doit \u00eatre une valeur sup\u00e9rieure \u00e0 0")
    private @NotNull(message="Veuillez renseigner le nombre de threads d'I/O") @Positive(message="Le nombre de threads I/O doit \u00eatre une valeur sup\u00e9rieure \u00e0 0") Integer ioThreadCount = 1;
    @NotNull(message="Veuillez renseigner la taille du buffer d'envoie")
    @Positive(message="La taille du buffer d'envoie doit \u00eatre une valeur sup\u00e9rieure \u00e0 0")
    private @NotNull(message="Veuillez renseigner la taille du buffer d'envoie") @Positive(message="La taille du buffer d'envoie doit \u00eatre une valeur sup\u00e9rieure \u00e0 0") Long sendBufferSize = 102400L;
    @NotNull(message="Veuillez renseigner la taille du buffer de reception")
    @Positive(message="La taille du buffer de reception doit \u00eatre une valeur sup\u00e9rieure \u00e0 0")
    private @NotNull(message="Veuillez renseigner la taille du buffer de reception") @Positive(message="La taille du buffer de reception doit \u00eatre une valeur sup\u00e9rieure \u00e0 0") Long receiveBufferSize = 102400L;
    @NotNull(message="Veuillez renseigner la taille max des requetes")
    @Positive(message="La taille du max des requetes doit \u00eatre une valeur sup\u00e9rieure \u00e0 0")
    private @NotNull(message="Veuillez renseigner la taille max des requetes") @Positive(message="La taille du max des requetes doit \u00eatre une valeur sup\u00e9rieure \u00e0 0") Long maxRequestSize = 0x6400000L;
    private SslProtocol sslProtocol = SslProtocol.TLS;
    private SslClientAuthentication sslClientAuthentication = SslClientAuthentication.NONE;
    private List<String> initialTopics = null;
    @Valid
    private KeystoreProperties keystoreConfig;
    @Valid
    private KeystoreProperties truststoreConfig;
    @NotNull(message="Veuillez renseigner les propri\u00e9t\u00e9s des Borkers")
    @Size(min=1, message="Veuillez configurer au moins un broker")
    @Valid
    private @NotNull(message="Veuillez renseigner les propri\u00e9t\u00e9s des Borkers") @Size(min=1, message="Veuillez configurer au moins un broker") @Valid List<BrokerProperties> brokerConfigs = null;

    public String getJavaTemporaryDirectory() {
        return this.javaTemporaryDirectory == null ? System.getProperty("java.io.tmpDir") : this.javaTemporaryDirectory.trim();
    }

    public SslProtocol getSslProtocol() {
        return this.sslProtocol == null ? SslProtocol.TLS12 : this.sslProtocol;
    }

    public SslClientAuthentication getSslClientAuthentication() {
        return this.sslClientAuthentication == null ? SslClientAuthentication.NONE : this.sslClientAuthentication;
    }

    public Boolean getControlledShutdown() {
        return this.controlledShutdown == null ? Boolean.TRUE : this.controlledShutdown;
    }

    public Boolean getEnableDeleteTopics() {
        return this.enableDeleteTopics == null ? Boolean.TRUE : this.enableDeleteTopics;
    }

    public Integer getPartitionCount() {
        return this.partitionCount == null ? 1 : this.partitionCount;
    }

    public Integer getNetworkThreadCount() {
        return this.networkThreadCount == null ? 1 : this.networkThreadCount;
    }

    public Integer getIoThreadCount() {
        return this.ioThreadCount == null ? 1 : this.ioThreadCount;
    }

    public Long getSendBufferSize() {
        return this.sendBufferSize == null ? 102400L : this.sendBufferSize;
    }

    public Long getReceiveBufferSize() {
        return this.receiveBufferSize == null ? 102400L : this.sendBufferSize;
    }

    public Long getMaxRequestSize() {
        return this.maxRequestSize == null ? 0x6400000L : this.maxRequestSize;
    }

    public void validate() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set constraintViolations = validator.validate((Object)this, new Class[0]);
        if (constraintViolations == null || constraintViolations.size() == 0) {
            return;
        }
        constraintViolations.forEach(constraintViolation -> {
            System.out.println("-------> Propriete : " + constraintViolation.getRootBeanClass() + "." + constraintViolation.getPropertyPath());
            System.out.println("-------> Valeur : " + constraintViolation.getInvalidValue());
            System.out.println("-------> Raison : " + constraintViolation.getMessage());
        });
        throw new RuntimeException("Violation des contraintes de validation des propri\u00e9t\u00e9 de configuration du Simulateur : " + constraintViolations);
    }

    public SimulatorProperties() {
    }

    public SimulatorProperties(Boolean enabled, String javaTemporaryDirectory, Boolean controlledShutdown, Boolean enableDeleteTopics, Integer partitionCount, Integer networkThreadCount, Integer ioThreadCount, Long sendBufferSize, Long receiveBufferSize, Long maxRequestSize, SslProtocol sslProtocol, SslClientAuthentication sslClientAuthentication, List<String> initialTopics, KeystoreProperties keystoreConfig, KeystoreProperties truststoreConfig, List<BrokerProperties> brokerConfigs) {
        this.enabled = enabled;
        this.javaTemporaryDirectory = javaTemporaryDirectory;
        this.controlledShutdown = controlledShutdown;
        this.enableDeleteTopics = enableDeleteTopics;
        this.partitionCount = partitionCount;
        this.networkThreadCount = networkThreadCount;
        this.ioThreadCount = ioThreadCount;
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
        this.maxRequestSize = maxRequestSize;
        this.sslProtocol = sslProtocol;
        this.sslClientAuthentication = sslClientAuthentication;
        this.initialTopics = initialTopics;
        this.keystoreConfig = keystoreConfig;
        this.truststoreConfig = truststoreConfig;
        this.brokerConfigs = brokerConfigs;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public List<String> getInitialTopics() {
        return this.initialTopics;
    }

    public KeystoreProperties getKeystoreConfig() {
        return this.keystoreConfig;
    }

    public KeystoreProperties getTruststoreConfig() {
        return this.truststoreConfig;
    }

    public List<BrokerProperties> getBrokerConfigs() {
        return this.brokerConfigs;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setJavaTemporaryDirectory(String javaTemporaryDirectory) {
        this.javaTemporaryDirectory = javaTemporaryDirectory;
    }

    public void setControlledShutdown(Boolean controlledShutdown) {
        this.controlledShutdown = controlledShutdown;
    }

    public void setEnableDeleteTopics(Boolean enableDeleteTopics) {
        this.enableDeleteTopics = enableDeleteTopics;
    }

    public void setPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
    }

    public void setNetworkThreadCount(Integer networkThreadCount) {
        this.networkThreadCount = networkThreadCount;
    }

    public void setIoThreadCount(Integer ioThreadCount) {
        this.ioThreadCount = ioThreadCount;
    }

    public void setSendBufferSize(Long sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setReceiveBufferSize(Long receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setMaxRequestSize(Long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public void setSslProtocol(SslProtocol sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setSslClientAuthentication(SslClientAuthentication sslClientAuthentication) {
        this.sslClientAuthentication = sslClientAuthentication;
    }

    public void setInitialTopics(List<String> initialTopics) {
        this.initialTopics = initialTopics;
    }

    public void setKeystoreConfig(KeystoreProperties keystoreConfig) {
        this.keystoreConfig = keystoreConfig;
    }

    public void setTruststoreConfig(KeystoreProperties truststoreConfig) {
        this.truststoreConfig = truststoreConfig;
    }

    public void setBrokerConfigs(List<BrokerProperties> brokerConfigs) {
        this.brokerConfigs = brokerConfigs;
    }

    public String toString() {
        return "SimulatorProperties(enabled=" + this.getEnabled() + ", javaTemporaryDirectory=" + this.getJavaTemporaryDirectory() + ", controlledShutdown=" + this.getControlledShutdown() + ", enableDeleteTopics=" + this.getEnableDeleteTopics() + ", partitionCount=" + this.getPartitionCount() + ", networkThreadCount=" + this.getNetworkThreadCount() + ", ioThreadCount=" + this.getIoThreadCount() + ", sendBufferSize=" + this.getSendBufferSize() + ", receiveBufferSize=" + this.getReceiveBufferSize() + ", maxRequestSize=" + this.getMaxRequestSize() + ", sslProtocol=" + (Object)((Object)this.getSslProtocol()) + ", sslClientAuthentication=" + (Object)((Object)this.getSslClientAuthentication()) + ", initialTopics=" + this.getInitialTopics() + ", keystoreConfig=" + this.getKeystoreConfig() + ", truststoreConfig=" + this.getTruststoreConfig() + ", brokerConfigs=" + this.getBrokerConfigs() + ")";
    }
}

