/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.properties;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import net.leadware.kafka.embedded.properties.ListenerProtocolProperties;
import net.leadware.kafka.embedded.properties.ListenerSecurityProtocol;

public class ListenerProperties {
    private static final ListenerProtocolProperties DEFAULT_PUBLIC_PROTOCOL = new ListenerProtocolProperties("PLAINTEXT", ListenerSecurityProtocol.PLAINTEXT);
    private static final ListenerProtocolProperties DEFAULT_ADMIN_PROTOCOL = new ListenerProtocolProperties("ADMIN", ListenerSecurityProtocol.PLAINTEXT);
    private static final ListenerProtocolProperties DEFAULT_INTERNAL_PRODUCER_PROTOCOL = new ListenerProtocolProperties("INTERNAL_PRODUCER", ListenerSecurityProtocol.PLAINTEXT);
    @Positive(message="La valeur du port d'\u00e9coute du broker ne peut \u00eatre nulle ou n\u00e9gative")
    @NotNull(message="Veuillez renseigner le num\u00e9ro de port d'\u00e9coute du broker")
    private @Positive(message="La valeur du port d'\u00e9coute du broker ne peut \u00eatre nulle ou n\u00e9gative") @NotNull(message="Veuillez renseigner le num\u00e9ro de port d'\u00e9coute du broker") Integer port = 0;
    private Integer adminPort = 0;
    private Integer internalProducerPort = 0;
    private ListenerProtocolProperties protocol = DEFAULT_PUBLIC_PROTOCOL;
    private ListenerProtocolProperties adminProtocol = DEFAULT_ADMIN_PROTOCOL;
    private ListenerProtocolProperties internalProducerProtocol = DEFAULT_INTERNAL_PRODUCER_PROTOCOL;

    public Integer getPort() {
        return this.port == null ? 0 : this.port;
    }

    public ListenerProtocolProperties getProtocol() {
        return this.protocol == null ? DEFAULT_PUBLIC_PROTOCOL : this.protocol;
    }

    public synchronized Integer getAdminPort() {
        return this.adminPort == null ? 0 : this.adminPort;
    }

    public Integer getInternalProducerPort() {
        return this.internalProducerPort == null ? 0 : this.internalProducerPort;
    }

    public ListenerProtocolProperties getAdminProtocol() {
        return this.adminProtocol == null ? DEFAULT_ADMIN_PROTOCOL : this.adminProtocol;
    }

    public ListenerProtocolProperties getInternalProducerProtocol() {
        return this.internalProducerProtocol == null ? DEFAULT_INTERNAL_PRODUCER_PROTOCOL : this.internalProducerProtocol;
    }

    public ListenerProperties() {
    }

    public ListenerProperties(Integer port, Integer adminPort, Integer internalProducerPort, ListenerProtocolProperties protocol, ListenerProtocolProperties adminProtocol, ListenerProtocolProperties internalProducerProtocol) {
        this.port = port;
        this.adminPort = adminPort;
        this.internalProducerPort = internalProducerPort;
        this.protocol = protocol;
        this.adminProtocol = adminProtocol;
        this.internalProducerProtocol = internalProducerProtocol;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setAdminPort(Integer adminPort) {
        this.adminPort = adminPort;
    }

    public void setInternalProducerPort(Integer internalProducerPort) {
        this.internalProducerPort = internalProducerPort;
    }

    public void setProtocol(ListenerProtocolProperties protocol) {
        this.protocol = protocol;
    }

    public void setAdminProtocol(ListenerProtocolProperties adminProtocol) {
        this.adminProtocol = adminProtocol;
    }

    public void setInternalProducerProtocol(ListenerProtocolProperties internalProducerProtocol) {
        this.internalProducerProtocol = internalProducerProtocol;
    }

    public String toString() {
        return "ListenerProperties(port=" + this.getPort() + ", adminPort=" + this.getAdminPort() + ", internalProducerPort=" + this.getInternalProducerPort() + ", protocol=" + this.getProtocol() + ", adminProtocol=" + this.getAdminProtocol() + ", internalProducerProtocol=" + this.getInternalProducerProtocol() + ")";
    }
}

