/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import net.leadware.kafka.embedded.KafkaSimulator;
import net.leadware.kafka.embedded.model.Topic;
import net.leadware.kafka.embedded.utils.KafkaSimulatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(description="Service Rest de gestion des topics", produces="application/json", consumes="application/json")
@ConditionalOnClass(value={KafkaSimulator.class, KafkaSimulatorFactory.class})
@ConditionalOnProperty(prefix="embedded.kafka.simulator", name={"enabled"}, havingValue="true", matchIfMissing=false)
@RestController
@RequestMapping(path={"/simulator/topic/api/1.0"}, produces={"application/json"}, consumes={"application/json"})
public class TopicController {
    @Autowired
    private KafkaSimulator kafkaSimulator;

    @ApiOperation(value="Op\u00e9ration de cr\u00e9ation d'un topic")
    @PostMapping(path={"/create"})
    @ResponseStatus(code=HttpStatus.CREATED)
    public void createTopic(@ApiParam(name="topic", required=true) @NotNull @RequestBody Topic topic) {
        this.kafkaSimulator.createTopics(topic.getName());
    }

    @ApiOperation(value="Op\u00e9ration de listage des topics en fonction de leur \u00e9tat de visibilit\u00e9")
    @ApiResponse(message="Liste des topics trouv\u00e9s", code=200)
    @GetMapping(path={"/topics/{internal}"}, consumes={"*/*"})
    @ResponseBody
    public List<Topic> listTopic(@ApiParam(name="internal", required=true) @PathVariable(value="internal") @NotNull Boolean internal) {
        return this.kafkaSimulator.listTopics(internal);
    }

    @ApiOperation(value="Op\u00e9ration de suppression d'un topic \u00e0 partir de son nom")
    @DeleteMapping(path={"/{topicName}"}, consumes={"*/*"})
    @ResponseStatus(code=HttpStatus.NO_CONTENT)
    public void deleteTopic(@ApiParam(name="topicName", required=true) @PathVariable(value="topicName") @NotEmpty String topicName) {
        this.kafkaSimulator.deleteTopics(topicName);
    }
}

