/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import javax.validation.constraints.NotEmpty;
import net.leadware.kafka.embedded.KafkaSimulator;
import net.leadware.kafka.embedded.utils.KafkaSimulatorFactory;
import net.leadware.kafka.embedded.utils.jsr303.format.FormatType;
import net.leadware.kafka.embedded.utils.jsr303.format.StringFormatValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(description="Service Rest de production de message Kafka sur le simulateur", produces="application/json", consumes="application/json")
@ConditionalOnClass(value={KafkaSimulator.class, KafkaSimulatorFactory.class})
@ConditionalOnProperty(prefix="embedded.kafka.simulator", name={"enabled"}, havingValue="true", matchIfMissing=false)
@RestController
@RequestMapping(path={"/simulator/producer/api/1.0"}, produces={"application/json"}, consumes={"application/json"})
@Validated
public class ProducerController {
    @Autowired
    private KafkaSimulator kafkaSimulator;

    @PostMapping(path={"/send/{topicName}/{messageKey}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK, reason="Message envoy\u00e9 dans la file")
    public void sendMessage(@ApiParam(name="topicName", value="Nom du topic d'envoi", required=true) @PathVariable(value="topicName") @NotEmpty String topicName, @ApiParam(name="messageKey", value="Cl\u00e9 du message KAFKA", required=true) @PathVariable(value="topicName") @NotEmpty String messageKey, @ApiParam(name="message", value="Contenu du message au format JSON", required=true) @RequestBody(required=true) @StringFormatValidator(format=FormatType.JSON) String message) {
        this.kafkaSimulator.sendMessage(topicName, messageKey, message);
    }

    @PostMapping(path={"/send/{topicName}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK, reason="Message envoy\u00e9 dans la file")
    public void sendMessage(@ApiParam(name="topicName", value="Nom du topic d'envoi", required=true) @PathVariable(value="topicName") @NotEmpty String topicName, @ApiParam(name="message", value="Contenu du message au format JSON", required=true) @RequestBody(required=true) @StringFormatValidator(format=FormatType.JSON) String message) {
        this.kafkaSimulator.sendMessage(topicName, message);
    }
}

