/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import net.leadware.kafka.embedded.KafkaSimulator;
import net.leadware.kafka.embedded.model.ConsumerGroup;
import net.leadware.kafka.embedded.model.ConsumerGroupOffset;
import net.leadware.kafka.embedded.utils.KafkaSimulatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(description="Service Rest de gestion des groupes de consommateurs", produces="application/json", consumes="application/json")
@ConditionalOnClass(value={KafkaSimulator.class, KafkaSimulatorFactory.class})
@ConditionalOnProperty(prefix="embedded.kafka.simulator", name={"enabled"}, havingValue="true", matchIfMissing=false)
@RestController
@RequestMapping(path={"/simulator/api/1.0/consumers/groups"}, produces={"application/json"})
@Validated
public class ConsumerGroupController {
    @Autowired
    private KafkaSimulator kafkaSimulator;

    @ApiOperation(value="Op\u00e9ration de listage des groupes de consommateurs Kafka")
    @ApiResponse(message="Liste des groupes de consommateurs trouv\u00e9s", code=200)
    @GetMapping
    @ResponseBody
    public List<ConsumerGroup> listConsumerGroup() {
        return this.kafkaSimulator.listConsumerGroup();
    }

    @ApiOperation(value="Op\u00e9ration de listage des offsets d'un groupe de consommateurs Kafka")
    @ApiResponse(message="Liste des offsets d'un groupe de consommateurs trouv\u00e9s", code=200)
    @GetMapping(path={"/{groupId}/offsets"})
    @ResponseBody
    public List<ConsumerGroupOffset> listConsumerGroupOffsets(@ApiParam(name="groupId", required=true) @PathVariable(value="groupId") @NotEmpty(message="Le param\u00e8tre 'groupId' doit \u00eatre renseign\u00e9") @NotEmpty(message="Le param\u00e8tre 'groupId' doit \u00eatre renseign\u00e9") String groupId) {
        return this.kafkaSimulator.listConsumerGroupOffsets(groupId);
    }
}

