/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.validator.base;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.leadware.persistence.tools.api.dao.constants.DAOMode;
import net.leadware.persistence.tools.api.dao.constants.DAOValidatorEvaluationTime;
import net.leadware.persistence.tools.api.dao.constants.ValidatorExpressionType;
import net.leadware.persistence.tools.api.validator.base.IDAOValidator;
import net.leadware.persistence.tools.core.dao.utils.DAOValidatorHelper;
import net.leadware.persistence.tools.core.dao.utils.ExpressionModel;

public abstract class AbstractExpressionBasedDAOValidatorRule
implements IDAOValidator<Annotation> {
    protected EntityManager entityManager;
    protected Annotation annotation;
    protected ExpressionModel expressionModel;
    protected DAOValidatorEvaluationTime systemEvaluationTime;
    protected DAOMode systemDAOMode;

    protected abstract String getExpression();

    protected abstract String getMessage();

    protected abstract ValidatorExpressionType getType();

    protected abstract DAOMode[] getAnnotationMode();

    protected abstract DAOValidatorEvaluationTime[] getAnnotationEvaluationTime();

    public void initialize(Annotation annotation, EntityManager entityManager, DAOMode systemMode, DAOValidatorEvaluationTime systemEvaluationTime) {
        this.annotation = annotation;
        this.entityManager = entityManager;
        this.systemDAOMode = systemMode;
        this.systemEvaluationTime = systemEvaluationTime;
        String expression = this.getExpression();
        this.expressionModel = DAOValidatorHelper.computeExpression(expression);
    }

    protected Query buildQuery(Object target) {
        if (this.expressionModel == null) {
            return null;
        }
        Query query = this.entityManager.createQuery(this.expressionModel.getComputedExpression());
        Map<String, String> parameters = this.expressionModel.getParameters();
        if (parameters != null && parameters.size() > 0) {
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                query.setParameter(key, DAOValidatorHelper.evaluateValueExpression(parameters.get(key), target));
            }
        }
        return query;
    }

    protected boolean isProcessable() {
        boolean correctMode = DAOValidatorHelper.arraryContains(this.getAnnotationMode(), this.systemDAOMode);
        boolean correctTime = DAOValidatorHelper.arraryContains(this.getAnnotationEvaluationTime(), this.systemEvaluationTime);
        return correctMode && correctTime;
    }

    public String[] getMessageParameters(Object entity) {
        String[] parametersExpressions = this.getMessageParametersExpressions();
        if (parametersExpressions == null || parametersExpressions.length == 0) {
            return null;
        }
        ArrayList<String> lParameters = new ArrayList<String>();
        ExpressionModel expressionModel = null;
        for (String expr : parametersExpressions) {
            try {
                expressionModel = DAOValidatorHelper.computeExpression(expr);
                Map<String, String> exprParameters = expressionModel.getParameters();
                if (exprParameters == null || exprParameters.size() == 0) continue;
                Set<String> keySet = exprParameters.keySet();
                for (String key : keySet) {
                    try {
                        lParameters.add(DAOValidatorHelper.evaluateValueExpression(exprParameters.get(key), entity).toString());
                    }
                    catch (Exception e) {
                        lParameters.add("[" + key + "]");
                    }
                }
            }
            catch (Exception e) {
                lParameters.add("[" + expr + "]");
            }
        }
        String[] parameters = new String[lParameters.size()];
        for (int i = 0; i < lParameters.size(); ++i) {
            parameters[i] = (String)lParameters.get(i);
        }
        return parameters;
    }

    protected abstract String[] getMessageParametersExpressions();
}

