/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.core.dao.utils;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.TreeValueExpression;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.el.ELContext;
import javax.el.ELResolver;
import net.leadware.persistence.tools.api.validator.annotations.EntityExistValidator;
import net.leadware.persistence.tools.api.validator.annotations.NotEmptyDAOValidator;
import net.leadware.persistence.tools.api.validator.annotations.NotEmptyDAOValidators;
import net.leadware.persistence.tools.api.validator.annotations.SizeDAOValidator;
import net.leadware.persistence.tools.api.validator.annotations.SizeDAOValidators;
import net.leadware.persistence.tools.api.validator.annotations.marker.DAOConstraint;
import net.leadware.persistence.tools.api.validator.base.IDAOValidator;
import net.leadware.persistence.tools.core.dao.utils.DAOValidatorBeanELResolver;
import net.leadware.persistence.tools.core.dao.utils.DAOValidatorELContext;
import net.leadware.persistence.tools.core.dao.utils.DAOValidatorMethodExpressionExecutor;
import net.leadware.persistence.tools.core.dao.utils.ExpressionModel;
import net.leadware.persistence.tools.validator.EntityExistValidatorRule;
import net.leadware.persistence.tools.validator.NotEmptyDAOValidatorRule;
import net.leadware.persistence.tools.validator.NotEmptyDAOValidatorsRule;
import net.leadware.persistence.tools.validator.SizeDAOValidatorRule;
import net.leadware.persistence.tools.validator.SizeDAOValidatorsRule;

public class DAOValidatorHelper {
    private static Map<String, Class<? extends IDAOValidator<? extends Annotation>>> mValidatorMapping = new HashMap<String, Class<? extends IDAOValidator<? extends Annotation>>>();
    public static String SIMPLE_LEFT_DELIMITER;
    public static String SIMPLE_RIGHT_DELIMITER;
    public static String ENV_LEFT_DELIMITER;
    public static String ENV_OPEN;
    public static String ENV_CLOSE;
    public static String ENV;
    public static String ENV_CHAIN_PATTERN;
    public static String FUNCTION_LEFT_DELIMITER;
    public static String FUNCTION_NAME;
    public static String FUNCTION_OPEN;
    public static String FUNCTION_CLOSE;
    public static String FUNCTION_PARAMETER;
    public static String SPLITTER_CHAIN;
    public static String SIMPLE_FUNCTION_LEFT_DELIMITER;
    public static String SIMPLE_FUNCTION_OPEN;
    public static String SIMPLE_FUNCTION_CLOSE;
    public static String FUNC_CHAIN_PATTERN;

    public static boolean isDAOValidatorAnnotation(Annotation annotation) {
        if (annotation == null) {
            return false;
        }
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        DAOConstraint logicAnnotation = annotationClass.getAnnotation(DAOConstraint.class);
        return logicAnnotation != null;
    }

    public static List<Annotation> loadDAOValidatorAnnotations(Object object) {
        ArrayList<Annotation> daoAnnotations = new ArrayList<Annotation>();
        if (object == null) {
            return daoAnnotations;
        }
        Annotation[] objectAnnotations = object.getClass().getAnnotations();
        if (objectAnnotations == null || objectAnnotations.length == 0) {
            return daoAnnotations;
        }
        for (Annotation annotation : objectAnnotations) {
            if (!DAOValidatorHelper.isDAOValidatorAnnotation(annotation)) continue;
            daoAnnotations.add(annotation);
        }
        return daoAnnotations;
    }

    public static List<Class<? extends IDAOValidator<? extends Annotation>>> loadDAOValidatorClass(Object object) {
        ArrayList<Class<? extends IDAOValidator<? extends Annotation>>> result = new ArrayList<Class<? extends IDAOValidator<? extends Annotation>>>();
        if (object == null) {
            return result;
        }
        Annotation[] objectAnnotations = object.getClass().getAnnotations();
        if (objectAnnotations == null || objectAnnotations.length == 0) {
            return result;
        }
        for (Annotation annotation : objectAnnotations) {
            if (!DAOValidatorHelper.isDAOValidatorAnnotation(annotation)) continue;
            DAOConstraint daoAnnotation = annotation.annotationType().getAnnotation(DAOConstraint.class);
            result.add(daoAnnotation.validatedBy());
        }
        return result;
    }

    public static Class<? extends IDAOValidator<? extends Annotation>> getValidationLogicClass(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        Class<? extends IDAOValidator<? extends Annotation>> mappedLogicClass = mValidatorMapping.get(annotation.annotationType().getName());
        if (mappedLogicClass != null) {
            return mappedLogicClass;
        }
        DAOConstraint logicAnnotation = annotation.annotationType().getAnnotation(DAOConstraint.class);
        return logicAnnotation.validatedBy();
    }

    public static <T> boolean arraryContains(T[] array, T value) {
        if (array == null || array.length == 0) {
            return false;
        }
        if (value == null) {
            return false;
        }
        boolean modeIn = false;
        int index = 0;
        while (index < array.length && !modeIn) {
            T tValue = array[index++];
            modeIn = tValue.equals(value);
        }
        return modeIn;
    }

    public static boolean isExpressionContainsENV(String expression) {
        if (expression == null || expression.trim().length() == 0) {
            return false;
        }
        return DAOValidatorHelper.isExpressionContainPattern(expression, ENV_CHAIN_PATTERN);
    }

    public static String[] getENVTokens(String expression) {
        return DAOValidatorHelper.extractToken(expression, ENV_CHAIN_PATTERN);
    }

    public static String resolveEnvironmentsParameters(String expression) {
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        while (DAOValidatorHelper.isExpressionContainPattern(expression, ENV_CHAIN_PATTERN)) {
            String[] envs;
            for (String env : envs = DAOValidatorHelper.extractToken(expression, ENV_CHAIN_PATTERN)) {
                String cleanEnv = env.replace("${", "");
                cleanEnv = cleanEnv.replace("}", "");
                expression = expression.replace(env, System.getProperty(cleanEnv));
            }
        }
        return expression;
    }

    public static ExpressionModel computeExpression(String expression) {
        String parameterName;
        String currentExpression;
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        ExpressionModel expressionModel = new ExpressionModel(expression.trim());
        int i = 0;
        if (DAOValidatorHelper.isExpressionContainPattern(expression.trim(), FUNC_CHAIN_PATTERN)) {
            String[] functions;
            for (String function : functions = DAOValidatorHelper.extractToken(expression, FUNC_CHAIN_PATTERN)) {
                currentExpression = expressionModel.getComputedExpression();
                parameterName = "var" + i++;
                currentExpression = currentExpression.replace(function, ":" + parameterName);
                expressionModel.setComputedExpression(currentExpression);
                expressionModel.addParameter(parameterName, function);
            }
        }
        while (DAOValidatorHelper.isExpressionContainPattern(expressionModel.getComputedExpression(), ENV_CHAIN_PATTERN)) {
            String[] envs;
            for (String env : envs = DAOValidatorHelper.extractToken(expressionModel.getComputedExpression(), ENV_CHAIN_PATTERN)) {
                currentExpression = expressionModel.getComputedExpression();
                parameterName = "var" + i++;
                currentExpression = currentExpression.replace(env, ":" + parameterName);
                expressionModel.setComputedExpression(currentExpression);
                expressionModel.addParameter(parameterName, env);
            }
        }
        return expressionModel;
    }

    public static boolean isExpressionContainsFunction(String expression) {
        if (expression == null || expression.trim().length() == 0) {
            return false;
        }
        return DAOValidatorHelper.isExpressionContainPattern(expression, FUNC_CHAIN_PATTERN);
    }

    public static boolean isExpressionContainPattern(String expression, String pattern) {
        try {
            if (expression == null || expression.trim().length() == 0) {
                return false;
            }
            Pattern regex = Pattern.compile(".*" + pattern + ".*");
            return regex.matcher(expression).matches();
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException(pattern, e);
        }
    }

    public static String[] getFunctionTokens(String expression) {
        return DAOValidatorHelper.extractToken(expression, FUNC_CHAIN_PATTERN);
    }

    public static String extractFunctionName(String functionToken) {
        if (functionToken == null || functionToken.trim().length() == 0) {
            return functionToken;
        }
        int index0 = functionToken.indexOf(SIMPLE_FUNCTION_LEFT_DELIMITER);
        int index1 = functionToken.indexOf(SIMPLE_FUNCTION_OPEN);
        String fName = functionToken.substring(index0 + SIMPLE_FUNCTION_LEFT_DELIMITER.length(), index1);
        return fName;
    }

    public static String extractParameter(String expression) {
        if (expression == null || expression.trim().length() == 0) {
            return expression;
        }
        String functionName = DAOValidatorHelper.extractFunctionName(expression);
        int begin = 0;
        if (functionName != null && functionName.trim().length() > 0) {
            begin = expression.indexOf(functionName) + functionName.length() + 1;
        }
        int end = expression.lastIndexOf(SIMPLE_FUNCTION_CLOSE);
        return expression.substring(begin, end);
    }

    public static String[] extractToken(String expression, String pattern) {
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        if (pattern == null) {
            return null;
        }
        String[] spacePlitted = expression.split(SPLITTER_CHAIN);
        StringBuffer aTokens = new StringBuffer();
        int index = 0;
        for (String spaceToken : spacePlitted) {
            if (!DAOValidatorHelper.isExpressionContainPattern(spaceToken, pattern)) continue;
            if (index++ > 0) {
                aTokens.append("@");
            }
            aTokens.append(spaceToken);
        }
        return aTokens.toString().split("@");
    }

    public static Object evaluateValueExpression(String expression, Object target) {
        DAOValidatorMethodExpressionExecutor methodExecutor = new DAOValidatorMethodExpressionExecutor();
        DAOValidatorBeanELResolver resolver = new DAOValidatorBeanELResolver(null);
        DAOValidatorELContext context = new DAOValidatorELContext();
        ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        if (target == null) {
            return null;
        }
        String localExpression = expression;
        String functionName = null;
        Object result = null;
        if (DAOValidatorHelper.isExpressionContainPattern(expression, FUNC_CHAIN_PATTERN)) {
            Object parameterEvaluation = null;
            functionName = DAOValidatorHelper.extractFunctionName(expression);
            String functionParameter = DAOValidatorHelper.extractParameter(expression);
            if (DAOValidatorHelper.isExpressionContainPattern(functionParameter, FUNC_CHAIN_PATTERN)) {
                parameterEvaluation = DAOValidatorHelper.evaluateValueExpression(functionParameter, target);
            } else if (DAOValidatorHelper.isExpressionContainPattern(functionParameter, ENV_CHAIN_PATTERN)) {
                parameterEvaluation = DAOValidatorHelper.evaluateValueExpression(functionParameter, target);
            } else if (functionParameter != null && functionParameter.equals("$$")) {
                parameterEvaluation = target;
            }
            if (methodExecutor.getMethodsName().contains(functionName)) {
                if (functionParameter == null || functionParameter.trim().length() == 0) {
                    result = methodExecutor.invoke(functionName, new Object[0]);
                }
                result = methodExecutor.invoke(functionName, parameterEvaluation);
            } else {
                result = parameterEvaluation;
            }
        } else if (DAOValidatorHelper.isExpressionContainPattern(expression, ENV_CHAIN_PATTERN)) {
            resolver.setBase(target);
            context.setELResolver((ELResolver)resolver);
            TreeValueExpression ve = expressionFactory.createValueExpression((ELContext)context, localExpression, Object.class);
            result = ve.getValue((ELContext)context);
        }
        return result;
    }

    public static boolean checkContainsInvalidCharacter(String text, String invalidCharacters) {
        if (text == null || text.trim().length() == 0 || invalidCharacters == null) {
            return false;
        }
        for (char c : invalidCharacters.toCharArray()) {
            if (text.indexOf(new String(new char[]{c})) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlphaNumericString(String text) {
        Pattern pattern = Pattern.compile("\\w+");
        return text != null && text.trim().length() > 0 && pattern.matcher(text).matches();
    }

    public static void main(String[] args) {
        String chn1 = "from Country c where (c.code = ${code})";
        ExpressionModel model = DAOValidatorHelper.computeExpression(chn1);
        System.out.println("Expression Initiale: " + model.getOriginalExpression());
        System.out.println("Expression Compilee: " + model.getComputedExpression());
        System.out.println("Parametres         : " + model.getParameters());
    }

    static {
        mValidatorMapping.put(SizeDAOValidator.class.getName(), SizeDAOValidatorRule.class);
        mValidatorMapping.put(SizeDAOValidators.class.getName(), SizeDAOValidatorsRule.class);
        mValidatorMapping.put(NotEmptyDAOValidator.class.getName(), NotEmptyDAOValidatorRule.class);
        mValidatorMapping.put(NotEmptyDAOValidators.class.getName(), NotEmptyDAOValidatorsRule.class);
        mValidatorMapping.put(EntityExistValidator.class.getName(), EntityExistValidatorRule.class);
        SIMPLE_LEFT_DELIMITER = "${";
        SIMPLE_RIGHT_DELIMITER = "}";
        ENV_LEFT_DELIMITER = "\\$\\{";
        ENV_OPEN = "\\{";
        ENV_CLOSE = "\\}";
        ENV = "[\\w||\\.]+";
        ENV_CHAIN_PATTERN = ENV_LEFT_DELIMITER + ENV + ENV_CLOSE;
        FUNCTION_LEFT_DELIMITER = "\\$F_";
        FUNCTION_NAME = "\\w+";
        FUNCTION_OPEN = "\\(";
        FUNCTION_CLOSE = "\\)";
        FUNCTION_PARAMETER = "[\\w|\\W|\\.]+";
        SPLITTER_CHAIN = " |=|,|;|:|<|>|!|\\?|\\*|\\+|/|-|%|\\)|\\(";
        SIMPLE_FUNCTION_LEFT_DELIMITER = "$F_";
        SIMPLE_FUNCTION_OPEN = "(";
        SIMPLE_FUNCTION_CLOSE = ")";
        FUNC_CHAIN_PATTERN = FUNCTION_LEFT_DELIMITER + FUNCTION_NAME + FUNCTION_OPEN + FUNCTION_PARAMETER + FUNCTION_CLOSE;
    }
}

