/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.validator;

import java.lang.annotation.Annotation;
import javax.persistence.EntityManager;
import net.leadware.persistence.tools.api.dao.constants.DAOMode;
import net.leadware.persistence.tools.api.dao.constants.DAOValidatorEvaluationTime;
import net.leadware.persistence.tools.api.dao.constants.ValidatorExpressionType;
import net.leadware.persistence.tools.api.validator.annotations.EntityExistValidator;
import net.leadware.persistence.tools.api.validator.annotations.SizeDAOValidator;
import net.leadware.persistence.tools.api.validator.base.IDAOValidator;
import net.leadware.persistence.tools.validator.SizeDAOValidatorRule;

public class EntityExistValidatorRule
implements IDAOValidator<EntityExistValidator> {
    protected EntityManager entityManager;
    protected EntityExistValidator annotation;
    protected DAOValidatorEvaluationTime systemEvaluationTime;
    protected DAOMode systemDAOMode;
    protected SizeDAOValidatorRule sizeValidator = new SizeDAOValidatorRule();

    public void initialize(EntityExistValidator annotation, EntityManager entityManager, DAOMode mode, DAOValidatorEvaluationTime evaluationTime) {
        this.annotation = annotation;
        this.entityManager = entityManager;
        this.systemDAOMode = mode;
        this.systemEvaluationTime = evaluationTime;
    }

    public void processValidation(Object entity) {
        if (this.annotation.targetClass() == null) {
            return;
        }
        if (this.annotation.idField() == null || this.annotation.idField().trim().length() == 0) {
            return;
        }
        String ifField = this.annotation.idField().trim();
        StringBuffer requestBuffer = new StringBuffer();
        requestBuffer.append("from ");
        requestBuffer.append(this.annotation.targetClass().getName());
        requestBuffer.append(" c where ");
        requestBuffer.append("c.".concat(ifField));
        requestBuffer.append(" = ");
        requestBuffer.append("${" + ifField + "}");
        final String request = requestBuffer.toString();
        SizeDAOValidator sizeAnnotation = new SizeDAOValidator(){

            public DAOValidatorEvaluationTime[] evaluationTime() {
                return EntityExistValidatorRule.this.annotation.evaluationTime();
            }

            public String expr() {
                return request;
            }

            public long max() {
                return 1L;
            }

            public String message() {
                return EntityExistValidatorRule.this.annotation.message();
            }

            public long min() {
                return 1L;
            }

            public DAOMode[] mode() {
                return EntityExistValidatorRule.this.annotation.mode();
            }

            public ValidatorExpressionType type() {
                return EntityExistValidatorRule.this.annotation.type();
            }

            public Class<? extends Annotation> annotationType() {
                return SizeDAOValidator.class;
            }

            public String[] parameters() {
                return EntityExistValidatorRule.this.annotation.parameters();
            }
        };
        this.sizeValidator.initialize((Annotation)sizeAnnotation, this.entityManager, this.systemDAOMode, this.systemEvaluationTime);
        this.sizeValidator.processValidation(entity);
    }

    public String[] getMessageParameters(Object entity) {
        return null;
    }
}

