/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.generator.manager;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.leadware.persistence.tools.api.dao.constants.DAOMode;
import net.leadware.persistence.tools.api.dao.constants.DAOValidatorEvaluationTime;
import net.leadware.persistence.tools.api.generator.IFieldGenerator;
import net.leadware.persistence.tools.api.generator.annotaions.FieldGenerator;
import net.leadware.persistence.tools.api.generator.manager.ClassBasedDAOGeneratorManager;
import net.leadware.persistence.tools.generator.base.AbstractDAOGeneratorManager;

public class ClassBasedDAOGeneratorManagerImpl
extends AbstractDAOGeneratorManager
implements ClassBasedDAOGeneratorManager {
    public void processGeneration(Object entity, Field field) {
        if (!this.isProcessable()) {
            return;
        }
        FieldGenerator castedAnnotation = (FieldGenerator)this.annotation;
        Class generatorClass = castedAnnotation.generator();
        IFieldGenerator generator = null;
        try {
            generator = (IFieldGenerator)generatorClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("jpersistencetools.generator.classbased.error.instanciate", e);
        }
        generator.setEntityManager(this.entityManager);
        generator.setGeneratorEntityManager(this.generatorEntityManager);
        generator.setField(field);
        generator.setEntity(entity);
        generator.initialize();
        Serializable generatedValue = generator.generate();
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), entity.getClass());
            Method propertySetter = propertyDescriptor.getWriteMethod();
            propertySetter.invoke(entity, generatedValue);
        }
        catch (Exception e) {
            throw new RuntimeException("jpersistencetools.generator.classbased.error.update.field", e);
        }
    }

    @Override
    protected DAOMode[] getAnnotationMode() {
        FieldGenerator castedAnnotation = (FieldGenerator)this.annotation;
        return castedAnnotation.mode();
    }

    @Override
    protected DAOValidatorEvaluationTime[] getAnnotationEvaluationTime() {
        FieldGenerator castedAnnotation = (FieldGenerator)this.annotation;
        return castedAnnotation.evaluationTime();
    }
}

