/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.api.collection.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.leadware.persistence.tools.api.exceptions.JPersistenceToolsException;
import net.leadware.persistence.tools.core.dao.utils.DAOValidatorHelper;

public class ConverterUtil {
    public static <K, T> Map<K, T> convertCollectionToMap(Collection<T> collection, String keyPropertyName) {
        if (collection == null) {
            return null;
        }
        HashMap<Object, T> map = new HashMap<Object, T>();
        if (collection.size() == 0) {
            return map;
        }
        if (keyPropertyName == null || keyPropertyName.trim().length() == 0) {
            throw new JPersistenceToolsException("NoMapKeyPropertyException.message");
        }
        for (T object : collection) {
            try {
                Object keyProperty = DAOValidatorHelper.evaluateValueExpression("${" + keyPropertyName + "}", object);
                map.put(keyProperty, object);
            }
            catch (Exception e) {
                throw new JPersistenceToolsException("convertCollectionToMap.error", (Throwable)e);
            }
        }
        return map;
    }

    public static <T> Set<T> convertCollectionToSet(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return new HashSet<T>(collection);
    }

    public static <T> List<T> convertCollectionToList(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <K, T> Collection<T> convertMapToCollection(Map<K, T> map) {
        if (map == null) {
            return null;
        }
        return map.values();
    }

    public static <K, T> List<T> convertMapToList(Map<K, T> map) {
        if (map == null) {
            return null;
        }
        return new ArrayList<T>(map.values());
    }

    public static <K, T> Set<T> convertMapToSet(Map<K, T> map) {
        if (map == null) {
            return null;
        }
        return new HashSet<T>(map.values());
    }

    public static <T> Set<T> convertArrayToSet(T ... objects) {
        if (objects == null) {
            return null;
        }
        HashSet<T> set = new HashSet<T>();
        for (T object : objects) {
            set.add(object);
        }
        return set;
    }

    public static <T> List<T> convertArrayToList(T ... objects) {
        if (objects == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T object : objects) {
            list.add(object);
        }
        return list;
    }
}

