/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.api.validator.jsr303ext;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.leadware.persistence.tools.api.validator.jsr303ext.annotations.AuthorizedValues;

public class AuthorizedValuesRule
implements ConstraintValidator<AuthorizedValues, Object> {
    private String[] values = new String[0];
    private boolean caseSensitive = false;

    public void initialize(AuthorizedValues annotation) {
        if (annotation == null) {
            return;
        }
        String[] annotationValues = annotation.values();
        if (annotationValues == null || annotationValues.length == 0) {
            return;
        }
        this.values = annotationValues;
        this.caseSensitive = annotation.caseSensitive();
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintContext) {
        if (this.values == null || this.values.length == 0) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String stringValue = ((String)value).trim();
            if (stringValue.length() == 0) {
                return false;
            }
            if (this.caseSensitive) {
                for (String authValue : this.values) {
                    if (stringValue.equals(authValue.trim())) continue;
                    return false;
                }
            } else {
                for (String authValue : this.values) {
                    if (stringValue.equalsIgnoreCase(authValue.trim())) continue;
                    return false;
                }
            }
        } else {
            for (String authValue : this.values) {
                if (value.equals(authValue)) continue;
                return false;
            }
        }
        return true;
    }
}

