/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.api.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.leadware.persistence.tools.api.dao.constants.OrderType;

public class OrderContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, OrderType> orders = new HashMap<String, OrderType>();

    public static OrderContainer newInstance() {
        return new OrderContainer();
    }

    public OrderContainer add(String property, OrderType orderType) {
        if (property == null || property.trim().length() == 0) {
            return this;
        }
        if (orderType == null) {
            return this;
        }
        this.orders.put(property.trim(), orderType);
        return this;
    }

    public Map<String, OrderType> getOrders() {
        return Collections.unmodifiableMap(this.orders);
    }

    public int size() {
        return this.orders.size();
    }

    public void clear() {
        if (this.orders != null) {
            this.orders.clear();
        }
    }
}

