/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.hibernate4.maven.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import net.leadware.hibernate4.maven.plugin.ExtendedScripts;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

@Mojo(name="hbm2ddl", defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES, threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ShemaExportMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter
    private String unitName;
    @Parameter(defaultValue=";")
    private String delimiter;
    @Parameter(defaultValue="${project.build.directory}/hibernate/drop.sql")
    private String dropOutputFile;
    @Parameter(defaultValue="${project.build.directory}/hibernate/create.sql")
    private String createOutputFile;
    @Parameter
    private String updateOutputFile;
    @Parameter
    private String dialect;
    @Parameter
    private String persistenceFile;
    @Parameter(property="extendedScripts")
    private ExtendedScripts extendedScripts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Exportation de l'Unite de persistence: " + this.unitName + "."));
        this.initOutputDirectory();
        File dropFile = new File(this.dropOutputFile.trim());
        File createFile = new File(this.createOutputFile.trim());
        File updateFile = null;
        Thread currentThread = Thread.currentThread();
        PrintStream oldOut = System.out;
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        try {
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            currentThread.setContextClassLoader(this.buildClassLoader(oldClassLoader));
            Ejb3Configuration jpaConfiguration = null;
            jpaConfiguration = this.persistenceFile != null && !this.persistenceFile.trim().isEmpty() ? new Ejb3Configuration().addFile(this.persistenceFile).configure(this.unitName, null) : new Ejb3Configuration().configure(this.unitName, null);
            Configuration configuration = jpaConfiguration.getHibernateConfiguration();
            if (this.dialect != null && !this.dialect.trim().isEmpty()) {
                configuration.setProperty("hibernate.dialect", this.dialect.trim());
            }
            SchemaExport exporter = new SchemaExport(configuration);
            exporter.setDelimiter(this.delimiter);
            exporter.setOutputFile(dropFile.getAbsolutePath());
            exporter.execute(true, false, true, false);
            exporter.setOutputFile(createFile.getAbsolutePath());
            exporter.execute(true, false, false, true);
            if (this.updateOutputFile != null && !this.updateOutputFile.trim().isEmpty()) {
                SchemaUpdate updater = new SchemaUpdate(configuration);
                updateFile = new File(this.updateOutputFile.trim());
                updater.setOutputFile(updateFile.getAbsolutePath());
                updater.execute(true, true);
            }
            if (this.extendedScripts != null) {
                File scriptFile;
                for (String script : this.extendedScripts.getCreateScripts()) {
                    scriptFile = new File(script);
                    if (scriptFile.exists() && scriptFile.isFile()) {
                        FileUtils.fileAppend((String)createFile.getAbsolutePath(), (String)("\n\n" + FileUtils.fileRead((File)scriptFile)));
                        continue;
                    }
                    FileUtils.fileAppend((String)createFile.getAbsolutePath(), (String)("\n\t" + script));
                }
                for (String script : this.extendedScripts.getDropScripts()) {
                    scriptFile = new File(script);
                    if (scriptFile.exists() && scriptFile.isFile()) {
                        FileUtils.fileAppend((String)dropFile.getAbsolutePath(), (String)("\n\n" + FileUtils.fileRead((File)scriptFile)));
                        continue;
                    }
                    FileUtils.fileAppend((String)dropFile.getAbsolutePath(), (String)("\n\t" + script));
                }
                if (this.updateOutputFile != null && !this.updateOutputFile.trim().isEmpty()) {
                    for (String script : this.extendedScripts.getUpdateScripts()) {
                        scriptFile = new File(script);
                        if (scriptFile.exists() && scriptFile.isFile()) {
                            FileUtils.fileAppend((String)updateFile.getAbsolutePath(), (String)("\n\n" + FileUtils.fileRead((File)scriptFile)));
                            continue;
                        }
                        FileUtils.fileAppend((String)updateFile.getAbsolutePath(), (String)("\n\t" + script));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            System.setOut(oldOut);
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    private void initOutputDirectory() {
        File updateDir;
        File dropDir;
        File createDir = new File(this.createOutputFile.trim()).getParentFile();
        if (!createDir.exists()) {
            createDir.mkdirs();
        }
        if (!(dropDir = new File(this.dropOutputFile.trim()).getParentFile()).exists()) {
            dropDir.mkdirs();
        }
        if (this.updateOutputFile != null && !this.updateOutputFile.trim().isEmpty() && !(updateDir = new File(this.updateOutputFile.trim()).getParentFile()).exists()) {
            updateDir.mkdirs();
        }
    }

    private ClassLoader buildClassLoader(ClassLoader delegate) {
        try {
            ArrayList<String> classpathElements = new ArrayList<String>();
            classpathElements.addAll(this.project.getCompileClasspathElements());
            classpathElements.addAll(this.project.getRuntimeClasspathElements());
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            URLClassLoader buildedClassloader = new URLClassLoader(urls, delegate);
            return buildedClassloader;
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Erreur lors de la construction de ClassLoader Maven pour le Plugin");
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }
}

