/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.bean.validation.ext.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static boolean isExecutable(String path) {
        try {
            return FileUtils.getFile(path).canExecute();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWriteable(String path) {
        try {
            return FileUtils.getFile(path).canWrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isReadeable(String path) {
        try {
            log.debug("V\u00e9rification de l'\u00e9tat de lecture du fichier [{}]", (Object)path);
            return FileUtils.getFile(path).canRead();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isHidden(String path) {
        try {
            return FileUtils.getFile(path).isHidden();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFile(String path) {
        try {
            return FileUtils.getFile(path).isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDirectory(String path) {
        try {
            return FileUtils.getFile(path).isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean fileExists(String path) {
        try {
            return FileUtils.getFile(path) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isParentDirExists(String path) {
        try {
            return FileUtils.getFile(path).getParentFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static File getFile(String path) {
        try {
            if (path == null) {
                throw new FileNotFoundException("Le fichier 'null' n'existe pas");
            }
            log.debug("Obtention de l'URL du chemin [{}]...", (Object)path);
            String resolvedPath = FileUtils.getResolvedPath(path);
            log.debug("URL compl\u00e8te du chemin [{}] : [{}]", (Object)path, (Object)resolvedPath);
            if (FileUtils.fileInArchive(resolvedPath)) {
                throw new IOException("Impossible de construire un objet java.io.File depuis un fichier contenue dans une archive [{" + resolvedPath + "}]");
            }
            return ResourceUtils.getFile((String)path);
        }
        catch (FileNotFoundException e) {
            log.debug("Le fichier [{}] n'existe pas.", (Object)path);
            throw new RuntimeException("Le chemin n'existe pas : " + path, e);
        }
        catch (IOException e) {
            log.debug("Erreur survenue lors du traitement du fichier [{}] : [{}]", (Object)path, (Object)e.getMessage());
            throw new RuntimeException("Erreur survenue lors du traitement du fichier [{" + path + "}]", e);
        }
    }

    public static String getResolvedPath(String rawPath) {
        try {
            return ResourceUtils.getURL((String)rawPath).getFile();
        }
        catch (Exception e) {
            return rawPath;
        }
    }

    private static boolean fileInArchive(String path) {
        return path.contains("!/");
    }
}

