/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.bean.validation.ext.engine.file;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.leadware.bean.validation.ext.annotations.general.Length;

public class LengthRule
implements ConstraintValidator<Length, Object> {
    private int min;
    private int max;
    private boolean acceptNullObject;
    private boolean trimString;

    public void initialize(Length annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
        this.acceptNullObject = annotation.acceptNullObject();
        this.trimString = annotation.trimString();
    }

    public boolean isValid(Object obj, ConstraintValidatorContext constraintContext) {
        if (obj == null) {
            return this.acceptNullObject;
        }
        if (obj.getClass().isArray()) {
            int size = Array.getLength(obj);
            return size >= this.min && size <= this.max;
        }
        if (obj instanceof Collection) {
            int size = ((Collection)obj).size();
            return size >= this.min && size <= this.max;
        }
        if (obj instanceof Map) {
            int size = ((Map)obj).size();
            return size >= this.min && size <= this.max;
        }
        if (obj instanceof String) {
            int size;
            String localString = (String)obj;
            if (this.trimString) {
                localString = localString.trim();
            }
            return (size = localString.length()) >= this.min && size <= this.max;
        }
        return false;
    }
}

