/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.bean.validation.ext.engine.file;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.leadware.bean.validation.ext.annotations.general.IPV4;

public class IPV4Rule
implements ConstraintValidator<IPV4, String> {
    public void initialize(IPV4 annotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintContext) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String stringValue = value;
        if (stringValue == null || stringValue.length() == 0) {
            return false;
        }
        String[] parts = stringValue.split("\\.");
        if (parts == null || parts.length < 4) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\d+");
        for (String part : parts) {
            if (pattern.matcher(part).matches()) continue;
            return false;
        }
        return true;
    }
}

