/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.bean.validation.ext.engine.file;

import java.lang.annotation.Annotation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.leadware.bean.validation.ext.annotations.file.FileValidator;
import net.leadware.bean.validation.ext.tools.FileUtils;

public class FileValidatorEngine
implements ConstraintValidator<FileValidator, String> {
    private FileValidator fileValidator;

    public void initialize(FileValidator fileValidator) {
        super.initialize((Annotation)fileValidator);
        this.fileValidator = fileValidator;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.trim().isEmpty()) {
            return this.fileValidator.acceptOnEmptyField();
        }
        switch (this.fileValidator.visibility()) {
            case EXISTS: {
                switch (this.fileValidator.fileType()) {
                    case FILE: {
                        return FileUtils.isFile(value.trim());
                    }
                    case DIRECTORY: {
                        return FileUtils.isDirectory(value.trim());
                    }
                    case ANY: {
                        return FileUtils.fileExists(value.trim());
                    }
                }
                return FileUtils.fileExists(value.trim());
            }
            case NOTEXISTS: {
                switch (this.fileValidator.fileType()) {
                    case FILE: {
                        return !FileUtils.isFile(value.trim());
                    }
                    case DIRECTORY: {
                        return !FileUtils.isDirectory(value.trim());
                    }
                    case ANY: {
                        return !FileUtils.fileExists(value.trim());
                    }
                }
                return !FileUtils.fileExists(value.trim());
            }
            case PARENT_DIR_EXISTS: {
                return FileUtils.isParentDirExists(value.trim());
            }
            case HIDDEN: {
                return FileUtils.isHidden(value.trim());
            }
            case READEABLE: {
                return FileUtils.isReadeable(value.trim());
            }
            case WRITEABLE: {
                return FileUtils.isWriteable(value.trim());
            }
        }
        return false;
    }
}

