/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.util;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import net.lapismc.datastore.DataStore;
import net.lapismc.datastore.util.LapisURL;
import org.bukkit.plugin.java.JavaPlugin;
import org.h2.Driver;

public class ConnectionManager {
    private HikariDataSource ds;
    private final HikariConfig config = new HikariConfig();
    private final HikariDataSource noDB;

    public ConnectionManager(JavaPlugin core, LapisURL url, DataStore.StorageType type, String username, String password) {
        this.config.setPoolName(core.getName() + "-hikari");
        this.config.setMaximumPoolSize(2);
        this.config.setMinimumIdle(1);
        this.config.setMaxLifetime(TimeUnit.MINUTES.toMillis(1L));
        this.config.setDriverClassName(this.getDriverClass(type));
        this.config.setUsername(username);
        this.config.setPassword(password);
        this.config.setJdbcUrl(url.getURL(type, false));
        this.noDB = new HikariDataSource(this.config);
        this.config.setMaximumPoolSize(5);
        this.config.setMinimumIdle(2);
        this.config.setJdbcUrl(url.getURL(type, true));
        if (!type.equals((Object)DataStore.StorageType.MySQL)) {
            this.ds = new HikariDataSource(this.config);
        }
    }

    private String getDriverClass(DataStore.StorageType type) {
        switch (type) {
            case MySQL: {
                return "com.mysql.jdbc.jdbc2.optional.MysqlDataSource";
            }
            case H2: {
                return Driver.class.getName();
            }
            case SQLite: {
                return "org.sqlite.JDBC";
            }
        }
        return "";
    }

    public Connection getConnection(boolean includeDatabase) throws SQLException {
        if (includeDatabase) {
            if (this.ds == null) {
                this.ds = new HikariDataSource(this.config);
            }
            return this.ds.getConnection();
        }
        return this.noDB.getConnection();
    }

    public void shutdown() {
        this.ds.close();
    }
}

