/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class Table {
    private String name;
    private List<String> values;

    public Table(String name, String ... values) {
        this.name = name;
        this.values = new ArrayList<String>(Arrays.asList(values));
    }

    public abstract void createTable(Connection var1);

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getCommaSeparatedValues() {
        StringBuilder s = new StringBuilder();
        for (String value : this.values) {
            s.append(value).append(",");
        }
        if (s.length() > 1) {
            s.deleteCharAt(s.length() - 1);
        }
        return s.toString();
    }

    public String toString() {
        return this.name;
    }
}

