/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.lapismc.datastore.DataStore;
import net.lapismc.datastore.MySQL;
import net.lapismc.datastore.util.LapisURL;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class SQLite
extends MySQL {
    private final LapisURL url;

    public SQLite(JavaPlugin core, LapisURL url) {
        super(core);
        this.url = url;
        try {
            Class.forName("org.sqlite.JDBC").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataStore.StorageType getStorageType() {
        return DataStore.StorageType.SQLite;
    }

    @Override
    public void initialiseDataStore() {
        File f = this.url.getFile(DataStore.StorageType.SQLite);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        super.initialiseDataStore();
    }

    @Override
    Connection getConnection(boolean includeDatabase) {
        try {
            return DriverManager.getConnection(this.url.getURL(this.getStorageType(), false));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

