/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.lapismc.datastore.DataStore;
import net.lapismc.datastore.Table;
import net.lapismc.datastore.util.ConnectionManager;
import net.lapismc.datastore.util.LapisURL;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class MySQL
extends DataStore {
    Connection conn;
    ConnectionManager connectionManager;
    LapisURL url;

    MySQL(JavaPlugin core) {
        super(core);
    }

    public MySQL(JavaPlugin core, LapisURL url, String username, String password) {
        super(core);
        this.url = url;
        this.connectionManager = new ConnectionManager(core, url, this.getStorageType(), username, password);
    }

    @Override
    public void initialiseDataStore() {
        try {
            this.createDatabase();
            this.createTables(this.getConnection(true));
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public DataStore.StorageType getStorageType() {
        return DataStore.StorageType.MySQL;
    }

    Connection getConnection(boolean includeDatabase) {
        this.closeConnection();
        try {
            this.conn = this.connectionManager.getConnection(includeDatabase);
            while (this.conn.isClosed()) {
                this.conn = this.connectionManager.getConnection(includeDatabase);
            }
            return this.conn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
            this.conn = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        this.closeConnection();
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    public void createDatabase() {
        if (this.getStorageType().equals((Object)DataStore.StorageType.MySQL)) {
            try {
                Statement stmt = this.getConnection(false).createStatement();
                stmt.execute("CREATE DATABASE IF NOT EXISTS " + this.url.getDatabase() + ";");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
    }

    @Override
    public void addData(Table table, String primaryKey, String primaryValue, String values) {
        this.runTask(() -> {
            if (primaryValue.equals(this.getString(table, primaryKey, primaryValue, primaryKey))) {
                StringBuilder query = new StringBuilder("update " + table.getName() + " set ");
                List<String> columnNames = table.getValues();
                List<String> valuesList = Arrays.asList(values.split(this.valueSeparator));
                for (int i = 0; i < columnNames.size(); ++i) {
                    query.append(columnNames.get(i)).append("='").append(valuesList.get(i)).append("',");
                }
                query.deleteCharAt(query.length() - 1);
                query.append(" where ").append(primaryKey).append("='").append(primaryValue).append("'");
                try {
                    Statement stmt = this.getConnection(true).createStatement();
                    stmt.execute(query.toString());
                    stmt.close();
                }
                catch (SQLException e) {
                    this.core.getLogger().warning("An error occurred adding data to the database for " + this.core.getName() + ", Sometimes this is a false alarm, other times the data might not have been set.If you experience errors, please report them with the following line.");
                    this.core.getLogger().warning(e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            } else {
                boolean async = this.isAsync();
                this.setAsync(false);
                this.addData(table, values);
                this.setAsync(async);
            }
        });
    }

    @Override
    public void addData(Table table, String values) {
        this.runTask(() -> {
            try {
                String valuesQuery = this.getQuery(table.getCommaSeparatedValues());
                String sql = "INSERT INTO " + table.getName() + "(" + table.getCommaSeparatedValues() + ") VALUES(" + valuesQuery + ")";
                PreparedStatement preStatement = this.getConnection(true).prepareStatement(sql, 1);
                int i = 1;
                for (String s : values.split(this.valueSeparator)) {
                    preStatement.setString(i, s);
                    ++i;
                }
                preStatement.execute();
                preStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        });
    }

    @Override
    public void setData(Table table, String primaryKey, String primaryValue, String key, String value) {
        this.runTask(() -> {
            try {
                String sqlUpdate = "UPDATE " + table.getName() + " SET " + key + " = ? WHERE " + primaryKey + " = ?";
                PreparedStatement preStatement = this.getConnection(true).prepareStatement(sqlUpdate);
                preStatement.setString(1, value);
                preStatement.setString(2, primaryValue);
                preStatement.execute();
                preStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLong(Table table, String primaryKey, String value, String key) {
        ResultSet rs = this.getResults(table, primaryKey, value);
        if (this.incrementIfValid(rs)) {
            try {
                Long l = rs.getLong(key);
                return l;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(Table table, String primaryKey, String value, String key) {
        ResultSet rs = this.getResults(table, primaryKey, value);
        if (this.incrementIfValid(rs)) {
            try {
                String string = rs.getString(key);
                return string;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getBoolean(Table table, String primaryKey, String value, String key) {
        ResultSet rs = this.getResults(table, primaryKey, value);
        if (this.incrementIfValid(rs)) {
            try {
                Boolean bl = rs.getInt(key) == 1;
                return bl;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(Table table, String primaryKey, String value, String key) {
        ResultSet rs = this.getResults(table, primaryKey, value);
        if (this.incrementIfValid(rs)) {
            try {
                Object object = rs.getObject(key);
                return object;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getLongList(Table table, String primaryKey, String value, String key) {
        ResultSet rs = this.getResults(table, primaryKey, value);
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            while (this.incrementIfValid(rs)) {
                list.add(rs.getLong(key));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return list;
    }

    @Override
    public List<String> getStringList(Table table, String primaryKey, String value, String key) {
        ResultSet rs = this.getResults(table, primaryKey, value);
        ArrayList<String> list = new ArrayList<String>();
        this.getStringListFromResultSet(key, rs, list);
        return list;
    }

    @Override
    public List<String> getEntireColumn(Table table, String key) {
        ResultSet rs = this.getEntireTableAsResultSet(table);
        ArrayList<String> list = new ArrayList<String>();
        this.getStringListFromResultSet(key, rs, list);
        return list;
    }

    @Override
    public List<String> getEntireRow(Table table, String primaryKey, String value) {
        ResultSet rs = this.getEntireTableAsResultSet(table);
        ArrayList<String> list = new ArrayList<String>();
        try {
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            while (this.incrementIfValid(rs)) {
                if (!rs.getString(primaryKey).equals(value)) continue;
                for (int i = 1; i <= columnCount; ++i) {
                    list.add(rs.getString(i));
                }
                break;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStringListFromResultSet(String key, ResultSet rs, List<String> list) {
        try {
            while (this.incrementIfValid(rs)) {
                list.add(rs.getString(key));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void removeData(Table table, String key, String value) {
        this.runTask(() -> {
            try {
                String sqlUpdate = "DELETE FROM " + table.getName() + " WHERE " + key + " = ?";
                PreparedStatement preStatement = this.getConnection(true).prepareStatement(sqlUpdate);
                preStatement.setString(1, value);
                preStatement.execute();
                preStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        });
    }

    @Override
    public void removeAllData(Table table) {
        this.runTask(() -> {
            try {
                String sqlUpdate = "DELETE FROM " + table.getName();
                Statement stmt = this.getConnection(true).createStatement();
                stmt.execute(sqlUpdate);
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        });
    }

    @Override
    protected void dropTable(Table table) {
        this.runTask(() -> {
            try {
                String sqlUpdate = "DROP TABLE " + table.getName();
                Statement stmt = this.getConnection(true).createStatement();
                stmt.execute(sqlUpdate);
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        });
    }

    @Override
    public List<String> getEntireTable(Table table) {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = this.getEntireTableAsResultSet(table);
        while (this.incrementIfValid(rs)) {
            try {
                StringBuilder entry = new StringBuilder();
                for (String columnName : table.getValues()) {
                    entry.append(rs.getString(columnName)).append(this.valueSeparator);
                }
                if (entry.length() > 1) {
                    entry.deleteCharAt(entry.length() - 1);
                }
                list.add(entry.toString());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private ResultSet getResults(Table table, String primaryKey, String value) {
        try {
            String sqlUpdate = "SELECT * FROM " + table.getName() + " WHERE " + primaryKey + " = ?";
            PreparedStatement preStatement = this.getConnection(true).prepareStatement(sqlUpdate);
            preStatement.setString(1, value);
            return preStatement.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ResultSet getEntireTableAsResultSet(Table table) {
        try {
            Statement stmt = this.getConnection(true).createStatement();
            String sql = "SELECT * FROM " + table.getName();
            return stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean incrementIfValid(ResultSet rs) {
        try {
            if (rs == null) {
                return false;
            }
            if (rs.isClosed()) {
                return false;
            }
            if (rs.isAfterLast()) {
                return false;
            }
            try {
                return rs.next();
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void runTask(Runnable task) {
        if (this.isAsync()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.core, task);
        } else {
            task.run();
        }
    }

    public abstract void createTables(Connection var1);

    private String getQuery(String values) {
        String[] valuesArray;
        StringBuilder query = new StringBuilder();
        for (String ignored : valuesArray = values.split(",")) {
            query.append("?,");
        }
        return query.substring(0, query.toString().length() - 1);
    }
}

