/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.lapismc.datastore.DataStore;
import net.lapismc.datastore.MySQL;
import net.lapismc.datastore.util.LapisURL;
import org.bukkit.plugin.java.JavaPlugin;
import org.h2.Driver;

public abstract class H2
extends MySQL {
    private final LapisURL url;

    public H2(JavaPlugin core, LapisURL url) {
        super(core);
        Driver.load();
        this.url = url;
    }

    @Override
    public DataStore.StorageType getStorageType() {
        return DataStore.StorageType.H2;
    }

    @Override
    public void initialiseDataStore() {
        File f = this.url.getFile(DataStore.StorageType.H2);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        super.initialiseDataStore();
    }

    @Override
    Connection getConnection(boolean includeDatabase) {
        try {
            return DriverManager.getConnection(this.url.getURL(this.getStorageType(), false));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

