/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import net.lapismc.datastore.DataStore;
import net.lapismc.datastore.drivers.h2.Driver;
import net.lapismc.datastore.drivers.hikari.HikariConfig;
import net.lapismc.datastore.drivers.hikari.HikariDataSource;
import net.lapismc.datastore.util.LapisURL;
import net.lapismc.lapiscore.LapisCorePlugin;

public class ConnectionManager {
    private HikariDataSource ds;
    private HikariConfig config = new HikariConfig();
    private HikariDataSource noDB;

    public ConnectionManager(LapisCorePlugin core, LapisURL url, DataStore.StorageType type, String username, String password) {
        this.config.setPoolName(core.getName() + "-hikari");
        this.config.setMaximumPoolSize(2);
        this.config.setMinimumIdle(1);
        this.config.setMaxLifetime(TimeUnit.MINUTES.toMillis(1L));
        this.config.setDriverClassName(this.getDriverClass(type));
        this.config.setUsername(username);
        this.config.setPassword(password);
        this.config.setJdbcUrl(url.getURL(type, false));
        this.noDB = new HikariDataSource(this.config);
        this.config.setMaximumPoolSize(5);
        this.config.setMinimumIdle(2);
        this.config.setJdbcUrl(url.getURL(type, true));
        if (!type.equals((Object)DataStore.StorageType.MySQL)) {
            this.ds = new HikariDataSource(this.config);
        }
    }

    private String getDriverClass(DataStore.StorageType type) {
        switch (type) {
            case MySQL: {
                return "com.mysql.jdbc.jdbc2.optional.MysqlDataSource";
            }
            case H2: {
                return Driver.class.getName();
            }
            case SQLite: {
                return "net.lapismc.datastore.drivers.sqlite.JDBC";
            }
        }
        return "";
    }

    public Connection getConnection(boolean includeDatabase) throws SQLException {
        if (includeDatabase) {
            if (this.ds == null) {
                this.ds = new HikariDataSource(this.config);
            }
            return this.ds.getConnection();
        }
        return this.noDB.getConnection();
    }

    public void shutdown() {
        this.ds.close();
    }
}

