/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.ExpressionVisitor;
import net.lapismc.datastore.drivers.h2.message.Trace;
import net.lapismc.datastore.drivers.h2.table.Column;
import net.lapismc.datastore.drivers.h2.table.PlanItem;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.util.New;

public class Plan {
    private final TableFilter[] filters;
    private final HashMap<TableFilter, PlanItem> planItems = new HashMap();
    private final Expression[] allConditions;
    private final TableFilter[] allFilters;

    public Plan(TableFilter[] tableFilterArray, int n, Expression expression) {
        this.filters = new TableFilter[n];
        System.arraycopy(tableFilterArray, 0, this.filters, 0, n);
        final ArrayList<Expression> arrayList = New.arrayList();
        final ArrayList<TableFilter> arrayList2 = New.arrayList();
        if (expression != null) {
            arrayList.add(expression);
        }
        for (int i = 0; i < n; ++i) {
            TableFilter tableFilter = tableFilterArray[i];
            tableFilter.visit(new TableFilter.TableFilterVisitor(){

                @Override
                public void accept(TableFilter tableFilter) {
                    arrayList2.add(tableFilter);
                    if (tableFilter.getJoinCondition() != null) {
                        arrayList.add(tableFilter.getJoinCondition());
                    }
                }
            });
        }
        this.allConditions = arrayList.toArray(new Expression[0]);
        this.allFilters = arrayList2.toArray(new TableFilter[0]);
    }

    public PlanItem getItem(TableFilter tableFilter) {
        return this.planItems.get(tableFilter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        for (int i = 0; i < this.allFilters.length; ++i) {
            TableFilter tableFilter = this.allFilters[i];
            this.setEvaluatable(tableFilter, true);
            if (i < this.allFilters.length - 1 || tableFilter.getSession().getDatabase().getSettings().earlyFilter) {
                tableFilter.optimizeFullCondition(false);
            }
            tableFilter.removeUnusableIndexConditions();
        }
        for (TableFilter tableFilter : this.allFilters) {
            this.setEvaluatable(tableFilter, false);
        }
    }

    public double calculateCost(Session session) {
        Trace trace = session.getTrace();
        if (trace.isDebugEnabled()) {
            trace.debug("Plan       : calculate cost for plan {0}", Arrays.toString(this.allFilters));
        }
        double d = 1.0;
        boolean bl = false;
        HashSet<Column> hashSet = ExpressionVisitor.allColumnsForTableFilters(this.allFilters);
        for (int i = 0; i < this.allFilters.length; ++i) {
            TableFilter tableFilter = this.allFilters[i];
            if (trace.isDebugEnabled()) {
                trace.debug("Plan       :   for table filter {0}", tableFilter);
            }
            PlanItem planItem = tableFilter.getBestPlanItem(session, this.allFilters, i, hashSet);
            this.planItems.put(tableFilter, planItem);
            if (trace.isDebugEnabled()) {
                trace.debug("Plan       :   best plan item cost {0} index {1}", planItem.cost, planItem.getIndex().getPlanSQL());
            }
            d += d * planItem.cost;
            this.setEvaluatable(tableFilter, true);
            Expression object = tableFilter.getJoinCondition();
            if (object == null || object.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
            bl = true;
            break;
        }
        if (bl) {
            d = Double.POSITIVE_INFINITY;
        }
        if (trace.isDebugEnabled()) {
            session.getTrace().debug("Plan       : plan cost {0}", d);
        }
        for (TableFilter tableFilter : this.allFilters) {
            this.setEvaluatable(tableFilter, false);
        }
        return d;
    }

    private void setEvaluatable(TableFilter tableFilter, boolean bl) {
        tableFilter.setEvaluatable(tableFilter, bl);
        for (Expression expression : this.allConditions) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }
}

