/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.FunctionCall;
import net.lapismc.datastore.drivers.h2.expression.TableFunction;
import net.lapismc.datastore.drivers.h2.index.FunctionIndex;
import net.lapismc.datastore.drivers.h2.index.Index;
import net.lapismc.datastore.drivers.h2.index.IndexType;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.result.LocalResult;
import net.lapismc.datastore.drivers.h2.result.ResultInterface;
import net.lapismc.datastore.drivers.h2.result.Row;
import net.lapismc.datastore.drivers.h2.schema.Schema;
import net.lapismc.datastore.drivers.h2.table.Column;
import net.lapismc.datastore.drivers.h2.table.IndexColumn;
import net.lapismc.datastore.drivers.h2.table.Table;
import net.lapismc.datastore.drivers.h2.table.TableType;
import net.lapismc.datastore.drivers.h2.value.DataType;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueNull;
import net.lapismc.datastore.drivers.h2.value.ValueResultSet;

public class FunctionTable
extends Table {
    private final FunctionCall function;
    private final long rowCount;
    private Expression functionExpr;
    private LocalResult cachedResult;
    private Value cachedValue;

    public FunctionTable(Schema schema, Session session, Expression expression, FunctionCall functionCall) {
        super(schema, 0, functionCall.getName(), false, true);
        this.functionExpr = expression;
        this.function = functionCall;
        this.rowCount = functionCall instanceof TableFunction ? ((TableFunction)functionCall).getRowCount() : Long.MAX_VALUE;
        functionCall.optimize(session);
        int n = functionCall.getType();
        if (n != 18) {
            throw DbException.get(90000, functionCall.getName());
        }
        Expression[] expressionArray = functionCall.getArgs();
        int n2 = expressionArray.length;
        Expression[] expressionArray2 = new Expression[n2];
        for (int i = 0; i < n2; ++i) {
            expressionArray[i] = expressionArray[i].optimize(session);
            expressionArray2[i] = expressionArray[i];
        }
        ValueResultSet valueResultSet = functionCall.getValueForColumnList(session, expressionArray2);
        if (valueResultSet == null) {
            throw DbException.get(90000, functionCall.getName());
        }
        ResultSet resultSet = valueResultSet.getResultSet();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            Column[] columnArray = new Column[n3];
            for (int i = 0; i < n3; ++i) {
                columnArray[i] = new Column(resultSetMetaData.getColumnName(i + 1), DataType.getValueTypeFromResultSet(resultSetMetaData, i + 1), resultSetMetaData.getPrecision(i + 1), resultSetMetaData.getScale(i + 1), resultSetMetaData.getColumnDisplaySize(i + 1));
            }
            this.setColumns(columnArray);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public boolean canDrop() {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public TableType getTableType() {
        return null;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new FunctionIndex(this, IndexColumn.wrap(this.columns));
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public boolean canGetRowCount() {
        return this.rowCount != Long.MAX_VALUE;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public ResultInterface getResult(Session session) {
        ValueResultSet valueResultSet = this.getValueResultSet(session);
        if (valueResultSet == null) {
            return null;
        }
        if (this.cachedResult != null && this.cachedValue == valueResultSet) {
            this.cachedResult.reset();
            return this.cachedResult;
        }
        LocalResult localResult = LocalResult.read(session, valueResultSet.getResultSet(), 0);
        if (this.function.isDeterministic()) {
            this.cachedResult = localResult;
            this.cachedValue = valueResultSet;
        }
        return localResult;
    }

    public ResultSet getResultSet(Session session) {
        ValueResultSet valueResultSet = this.getValueResultSet(session);
        return valueResultSet == null ? null : valueResultSet.getResultSet();
    }

    private ValueResultSet getValueResultSet(Session session) {
        this.functionExpr = this.functionExpr.optimize(session);
        Value value = this.functionExpr.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        return (ValueResultSet)value;
    }

    public boolean isBufferResultSetToLocalTemp() {
        return this.function.isBufferResultSetToLocalTemp();
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public String getSQL() {
        return this.function.getSQL();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return this.function.isDeterministic();
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

