/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.table;

import java.util.Arrays;
import net.lapismc.datastore.drivers.h2.command.Parser;
import net.lapismc.datastore.drivers.h2.engine.DbObjectBase;
import net.lapismc.datastore.drivers.h2.engine.Mode;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.ConditionAndOr;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.ExpressionVisitor;
import net.lapismc.datastore.drivers.h2.expression.SequenceValue;
import net.lapismc.datastore.drivers.h2.expression.ValueExpression;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.result.Row;
import net.lapismc.datastore.drivers.h2.schema.Schema;
import net.lapismc.datastore.drivers.h2.schema.SchemaObject;
import net.lapismc.datastore.drivers.h2.schema.Sequence;
import net.lapismc.datastore.drivers.h2.table.SingleColumnResolver;
import net.lapismc.datastore.drivers.h2.table.Table;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.util.DateTimeUtils;
import net.lapismc.datastore.drivers.h2.util.MathUtils;
import net.lapismc.datastore.drivers.h2.util.StringUtils;
import net.lapismc.datastore.drivers.h2.value.DataType;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueDate;
import net.lapismc.datastore.drivers.h2.value.ValueEnum;
import net.lapismc.datastore.drivers.h2.value.ValueInt;
import net.lapismc.datastore.drivers.h2.value.ValueLong;
import net.lapismc.datastore.drivers.h2.value.ValueNull;
import net.lapismc.datastore.drivers.h2.value.ValueString;
import net.lapismc.datastore.drivers.h2.value.ValueTime;
import net.lapismc.datastore.drivers.h2.value.ValueTimestamp;
import net.lapismc.datastore.drivers.h2.value.ValueTimestampTimeZone;
import net.lapismc.datastore.drivers.h2.value.ValueUuid;

public class Column {
    public static final String ROWID = "_ROWID_";
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;
    private final int type;
    private long precision;
    private int scale;
    private String[] enumerators;
    private int displaySize;
    private Table table;
    private String name;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private Expression onUpdateExpression;
    private Expression checkConstraint;
    private String checkConstraintSQL;
    private String originalSQL;
    private boolean autoIncrement;
    private long start;
    private long increment;
    private boolean convertNullToDefault;
    private Sequence sequence;
    private boolean isComputed;
    private TableFilter computeTableFilter;
    private int selectivity;
    private SingleColumnResolver resolver;
    private String comment;
    private boolean primaryKey;
    private boolean visible = true;

    public Column(String string, int n) {
        this(string, n, -1L, -1, -1, null);
    }

    public Column(String string, int n, long l, int n2, int n3) {
        this(string, n, l, n2, n3, null);
    }

    public Column(String string, int n, long l, int n2, int n3, String[] stringArray) {
        this.name = string;
        this.type = n;
        if (l == -1L && n2 == -1 && n3 == -1 && n != -1) {
            DataType dataType = DataType.getDataType(n);
            l = dataType.defaultPrecision;
            n2 = dataType.defaultScale;
            n3 = dataType.defaultDisplaySize;
        }
        this.precision = l;
        this.scale = n2;
        this.displaySize = n3;
        this.enumerators = stringArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Column)) {
            return false;
        }
        Column column = (Column)object;
        if (this.table == null || column.table == null || this.name == null || column.name == null) {
            return false;
        }
        if (this.table != column.table) {
            return false;
        }
        return this.name.equals(column.name);
    }

    public int hashCode() {
        if (this.table == null || this.name == null) {
            return 0;
        }
        return this.table.getId() ^ this.name.hashCode();
    }

    public boolean isEnumerated() {
        return this.type == 25;
    }

    public Column getClone() {
        Column column = new Column(this.name, this.type, this.precision, this.scale, this.displaySize, this.enumerators);
        column.copy(this);
        return column;
    }

    public Value convert(Value value) {
        return this.convert(value, null);
    }

    public Value convert(Value value, Mode mode) {
        try {
            return value.convertTo(this.type, MathUtils.convertLongToInt(this.precision), mode, this, this.getEnumerators());
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 22018) {
                String string = (this.table == null ? "" : this.table.getName() + ": ") + this.getCreateSQL();
                throw DbException.get(22018, dbException, value.getSQL() + " (" + string + ")");
            }
            throw dbException;
        }
    }

    boolean getComputed() {
        return this.isComputed;
    }

    synchronized Value computeValue(Session session, Row row) {
        this.computeTableFilter.setSession(session);
        this.computeTableFilter.set(row);
        return this.defaultExpression.getValue(session);
    }

    public void setComputedExpression(Expression expression) {
        this.isComputed = true;
        this.defaultExpression = expression;
    }

    public void setTable(Table table, int n) {
        this.table = table;
        this.columnId = n;
    }

    public Table getTable() {
        return this.table;
    }

    public void setDefaultExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.defaultExpression = expression;
    }

    public void setOnUpdateExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.onUpdateExpression = expression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public String getSQL() {
        return Parser.quoteIdentifier(this.name);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public void setPrecision(long l) {
        this.precision = l;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public int getScale() {
        return this.scale;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public String[] getEnumerators() {
        return this.enumerators;
    }

    public void setEnumerators(String[] stringArray) {
        this.enumerators = stringArray;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value validateConvertUpdateSequence(Session session, Value value) {
        Object object;
        Expression expression;
        Object object2 = this;
        synchronized (object2) {
            expression = this.defaultExpression;
        }
        if (value == null) {
            if (expression == null) {
                value = ValueNull.INSTANCE;
            } else {
                value = expression.getValue(session).convertTo(this.type);
                session.getGeneratedKeys().add(this);
                if (this.primaryKey) {
                    session.setLastIdentity(value);
                }
            }
        }
        object2 = session.getDatabase().getMode();
        if (value == ValueNull.INSTANCE) {
            if (this.convertNullToDefault) {
                value = expression.getValue(session).convertTo(this.type);
                session.getGeneratedKeys().add(this);
            }
            if (value == ValueNull.INSTANCE && !this.nullable) {
                if (((Mode)object2).convertInsertNullToZero) {
                    object = DataType.getDataType(this.type);
                    if (((DataType)object).decimal) {
                        value = ValueInt.get(0).convertTo(this.type);
                    } else if (((DataType)object).type == 11) {
                        value = ValueTimestamp.fromMillis(session.getTransactionStart());
                    } else if (((DataType)object).type == 24) {
                        long l = session.getTransactionStart();
                        value = ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromDate(l), DateTimeUtils.nanosFromDate(l), (short)0);
                    } else {
                        value = ((DataType)object).type == 9 ? ValueTime.fromNanos(0L) : (((DataType)object).type == 10 ? ValueDate.fromMillis(session.getTransactionStart()) : ValueString.get("").convertTo(this.type));
                    }
                } else {
                    throw DbException.get(23502, this.name);
                }
            }
        }
        if (this.checkConstraint != null) {
            this.resolver.setValue(value);
            Column column = this;
            synchronized (column) {
                object = this.checkConstraint.getValue(session);
            }
            if (object != ValueNull.INSTANCE && !((Value)object).getBoolean()) {
                throw DbException.get(23513, this.checkConstraint.getSQL());
            }
        }
        value = value.convertScale(((Mode)object2).convertOnlyToSmallerScale, this.scale);
        if (this.precision > 0L && !value.checkPrecision(this.precision)) {
            object = value.getTraceSQL();
            if (((String)object).length() > 127) {
                object = ((String)object).substring(0, 128) + "...";
            }
            throw DbException.get(22001, this.getCreateSQL(), (String)object + " (" + value.getPrecision() + ")");
        }
        if (this.isEnumerated() && value != ValueNull.INSTANCE) {
            if (!ValueEnum.isValid(this.enumerators, value)) {
                object = value.getTraceSQL();
                if (((String)object).length() > 127) {
                    object = ((String)object).substring(0, 128) + "...";
                }
                throw DbException.get(22030, new String[]{this.getCreateSQL(), object});
            }
            value = ValueEnum.get(this.enumerators, value.getInt());
        }
        this.updateSequenceIfRequired(session, value);
        return value;
    }

    private void updateSequenceIfRequired(Session session, Value value) {
        if (this.sequence != null) {
            long l = this.sequence.getCurrentValue();
            long l2 = this.sequence.getIncrement();
            long l3 = value.getLong();
            boolean bl = false;
            if (l2 > 0L && l3 > l) {
                bl = true;
            } else if (l2 < 0L && l3 < l) {
                bl = true;
            }
            if (bl) {
                this.sequence.modify(l3 + l2, null, null, null);
                session.setLastIdentity(ValueLong.get(l3));
                this.sequence.flush(session);
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int n, boolean bl) {
        Object object;
        Object object2;
        String string;
        if (!this.autoIncrement) {
            DbException.throwInternalError();
        }
        if ("IDENTITY".equals(this.originalSQL)) {
            this.originalSQL = "BIGINT";
        } else if ("SERIAL".equals(this.originalSQL)) {
            this.originalSQL = "INT";
        }
        do {
            object = ValueUuid.getNewRandom();
            object2 = ((ValueUuid)object).getString();
            object2 = StringUtils.toUpperEnglish(((String)object2).replace('-', '_'));
        } while (schema.findSequence(string = "SYSTEM_SEQUENCE_" + (String)object2) != null);
        object = new Sequence(schema, n, string, this.start, this.increment);
        ((DbObjectBase)object).setTemporary(bl);
        session.getDatabase().addSchemaObject(session, (SchemaObject)object);
        this.setAutoIncrement(false, 0L, 0L);
        object2 = new SequenceValue((Sequence)object);
        this.setDefaultExpression(session, (Expression)object2);
        this.setSequence((Sequence)object);
    }

    public void prepareExpression(Session session) {
        if (this.defaultExpression != null || this.onUpdateExpression != null) {
            this.computeTableFilter = new TableFilter(session, this.table, null, false, null, 0, null);
            if (this.defaultExpression != null) {
                this.defaultExpression.mapColumns(this.computeTableFilter, 0);
                this.defaultExpression = this.defaultExpression.optimize(session);
            }
            if (this.onUpdateExpression != null) {
                this.onUpdateExpression.mapColumns(this.computeTableFilter, 0);
                this.onUpdateExpression = this.onUpdateExpression.optimize(session);
            }
        }
    }

    public String getCreateSQLWithoutName() {
        return this.getCreateSQL(false);
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    private String getCreateSQL(boolean bl) {
        String string;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl && this.name != null) {
            stringBuilder.append(Parser.quoteIdentifier(this.name)).append(' ');
        }
        if (this.originalSQL != null) {
            stringBuilder.append(this.originalSQL);
        } else {
            stringBuilder.append(DataType.getDataType((int)this.type).name);
            switch (this.type) {
                case 6: {
                    stringBuilder.append('(').append(this.precision).append(", ").append(this.scale).append(')');
                    break;
                }
                case 25: {
                    stringBuilder.append('(');
                    for (int i = 0; i < this.enumerators.length; ++i) {
                        stringBuilder.append('\'').append(this.enumerators[i]).append('\'');
                        if (i >= this.enumerators.length - 1) continue;
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(')');
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 21: {
                    if (this.precision >= Integer.MAX_VALUE) break;
                    stringBuilder.append('(').append(this.precision).append(')');
                    break;
                }
            }
        }
        if (!this.visible) {
            stringBuilder.append(" INVISIBLE ");
        }
        if (this.defaultExpression != null && (string2 = this.defaultExpression.getSQL()) != null) {
            if (this.isComputed) {
                stringBuilder.append(" AS ").append(string2);
            } else if (this.defaultExpression != null) {
                stringBuilder.append(" DEFAULT ").append(string2);
            }
        }
        if (this.onUpdateExpression != null && (string = this.onUpdateExpression.getSQL()) != null) {
            stringBuilder.append(" ON UPDATE ").append(string);
        }
        if (!this.nullable) {
            stringBuilder.append(" NOT NULL");
        }
        if (this.convertNullToDefault) {
            stringBuilder.append(" NULL_TO_DEFAULT");
        }
        if (this.sequence != null) {
            stringBuilder.append(" SEQUENCE ").append(this.sequence.getSQL());
        }
        if (this.selectivity != 0) {
            stringBuilder.append(" SELECTIVITY ").append(this.selectivity);
        }
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (this.checkConstraint != null) {
            stringBuilder.append(" CHECK ").append(this.checkConstraintSQL);
        }
        return stringBuilder.toString();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setOriginalSQL(String string) {
        this.originalSQL = string;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public Expression getOnUpdateExpression() {
        return this.onUpdateExpression;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean bl, long l, long l2) {
        this.autoIncrement = bl;
        this.start = l;
        this.increment = l2;
        this.nullable = false;
        if (bl) {
            this.convertNullToDefault = true;
        }
    }

    public void setConvertNullToDefault(boolean bl) {
        this.convertNullToDefault = bl;
    }

    public void rename(String string) {
        this.name = string;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int n) {
        this.selectivity = n = n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckConstraint(Session session, Expression expression) {
        if (expression == null) {
            return;
        }
        this.resolver = new SingleColumnResolver(this);
        Column column = this;
        synchronized (column) {
            String string = this.name;
            if (this.name == null) {
                this.name = "VALUE";
            }
            expression.mapColumns(this.resolver, 0);
            this.name = string;
        }
        expression = expression.optimize(session);
        this.resolver.setValue(ValueNull.INSTANCE);
        column = this;
        synchronized (column) {
            expression.getValue(session);
        }
        this.checkConstraint = this.checkConstraint == null ? expression : new ConditionAndOr(0, this.checkConstraint, expression);
        this.checkConstraintSQL = this.getCheckConstraintSQL(session, this.name);
    }

    public void removeCheckConstraint() {
        this.checkConstraint = null;
        this.checkConstraintSQL = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(Session session, String string) {
        String string2;
        if (this.checkConstraint == null) {
            return null;
        }
        Parser parser = new Parser(session);
        Column column = this;
        synchronized (column) {
            String string3 = this.name;
            this.name = string;
            string2 = this.checkConstraint.getSQL();
            this.name = string3;
        }
        return parser.parseExpression(string2);
    }

    String getDefaultSQL() {
        return this.defaultExpression == null ? null : this.defaultExpression.getSQL();
    }

    String getOnUpdateSQL() {
        return this.onUpdateExpression == null ? null : this.onUpdateExpression.getSQL();
    }

    int getPrecisionAsInt() {
        return MathUtils.convertLongToInt(this.precision);
    }

    DataType getDataType() {
        return DataType.getDataType(this.type);
    }

    String getCheckConstraintSQL(Session session, String string) {
        Expression expression = this.getCheckConstraint(session, string);
        return expression == null ? "" : expression.getSQL();
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 7 && this.sequence != null) {
            expressionVisitor.getDependencies().add(this.sequence);
        }
        if (this.defaultExpression != null && !this.defaultExpression.isEverything(expressionVisitor)) {
            return false;
        }
        return this.checkConstraint == null || this.checkConstraint.isEverything(expressionVisitor);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWideningConversion(Column column) {
        if (this.type != column.type) {
            return false;
        }
        if (this.precision > column.precision) {
            return false;
        }
        if (this.scale != column.scale) {
            return false;
        }
        if (this.nullable && !column.nullable) {
            return false;
        }
        if (this.convertNullToDefault != column.convertNullToDefault) {
            return false;
        }
        if (this.primaryKey != column.primaryKey) {
            return false;
        }
        if (this.autoIncrement || column.autoIncrement) {
            return false;
        }
        if (this.checkConstraint != null || column.checkConstraint != null) {
            return false;
        }
        if (this.convertNullToDefault || column.convertNullToDefault) {
            return false;
        }
        if (this.defaultExpression != null || column.defaultExpression != null) {
            return false;
        }
        if (this.isComputed || column.isComputed) {
            return false;
        }
        return this.onUpdateExpression == null && column.onUpdateExpression == null;
    }

    public void copy(Column column) {
        this.checkConstraint = column.checkConstraint;
        this.checkConstraintSQL = column.checkConstraintSQL;
        this.displaySize = column.displaySize;
        this.name = column.name;
        this.precision = column.precision;
        this.enumerators = column.enumerators == null ? null : Arrays.copyOf(column.enumerators, column.enumerators.length);
        this.scale = column.scale;
        this.nullable = column.nullable;
        this.defaultExpression = column.defaultExpression;
        this.onUpdateExpression = column.onUpdateExpression;
        this.originalSQL = column.originalSQL;
        this.convertNullToDefault = column.convertNullToDefault;
        this.sequence = column.sequence;
        this.comment = column.comment;
        this.computeTableFilter = column.computeTableFilter;
        this.isComputed = column.isComputed;
        this.selectivity = column.selectivity;
        this.primaryKey = column.primaryKey;
        this.visible = column.visible;
    }
}

