/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.server.pg;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.lapismc.datastore.drivers.h2.Driver;
import net.lapismc.datastore.drivers.h2.engine.Constants;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.server.Service;
import net.lapismc.datastore.drivers.h2.server.pg.PgServerThread;
import net.lapismc.datastore.drivers.h2.util.NetUtils;
import net.lapismc.datastore.drivers.h2.util.Tool;

public class PgServer
implements Service {
    public static final int DEFAULT_PORT = 5435;
    public static final int PG_TYPE_VARCHAR = 1043;
    public static final int PG_TYPE_BOOL = 16;
    public static final int PG_TYPE_BYTEA = 17;
    public static final int PG_TYPE_BPCHAR = 1042;
    public static final int PG_TYPE_INT8 = 20;
    public static final int PG_TYPE_INT2 = 21;
    public static final int PG_TYPE_INT4 = 23;
    public static final int PG_TYPE_TEXT = 25;
    public static final int PG_TYPE_OID = 26;
    public static final int PG_TYPE_FLOAT4 = 700;
    public static final int PG_TYPE_FLOAT8 = 701;
    public static final int PG_TYPE_UNKNOWN = 705;
    public static final int PG_TYPE_TEXTARRAY = 1009;
    public static final int PG_TYPE_DATE = 1082;
    public static final int PG_TYPE_TIME = 1083;
    public static final int PG_TYPE_TIMESTAMP_NO_TMZONE = 1114;
    public static final int PG_TYPE_NUMERIC = 1700;
    private final HashSet<Integer> typeSet = new HashSet();
    private int port = 5435;
    private boolean portIsSet;
    private boolean stop;
    private boolean trace;
    private ServerSocket serverSocket;
    private final Set<PgServerThread> running = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger pid = new AtomicInteger();
    private String baseDir;
    private boolean allowOthers;
    private boolean isDaemon;
    private boolean ifExists;
    private String key;
    private String keyDatabase;

    @Override
    public void init(String ... stringArray) {
        this.port = 5435;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (Tool.isOption(string, "-trace")) {
                this.trace = true;
                continue;
            }
            if (Tool.isOption(string, "-pgPort")) {
                this.port = Integer.decode(stringArray[++i]);
                this.portIsSet = true;
                continue;
            }
            if (Tool.isOption(string, "-baseDir")) {
                this.baseDir = stringArray[++i];
                continue;
            }
            if (Tool.isOption(string, "-pgAllowOthers")) {
                this.allowOthers = true;
                continue;
            }
            if (Tool.isOption(string, "-pgDaemon")) {
                this.isDaemon = true;
                continue;
            }
            if (Tool.isOption(string, "-ifExists")) {
                this.ifExists = true;
                continue;
            }
            if (!Tool.isOption(string, "-key")) continue;
            this.key = stringArray[++i];
            this.keyDatabase = stringArray[++i];
        }
        Driver.load();
    }

    boolean getTrace() {
        return this.trace;
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    synchronized void remove(PgServerThread pgServerThread) {
        this.running.remove(pgServerThread);
    }

    void traceError(Exception exception) {
        if (this.trace) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getURL() {
        return "pg://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    private boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.traceError(unknownHostException);
            return false;
        }
    }

    @Override
    public void start() {
        this.stop = false;
        try {
            this.serverSocket = NetUtils.createServerSocket(this.port, false);
        }
        catch (DbException dbException) {
            if (!this.portIsSet) {
                this.serverSocket = NetUtils.createServerSocket(0, false);
            }
            throw dbException;
        }
        this.port = this.serverSocket.getLocalPort();
    }

    @Override
    public void listen() {
        block4: {
            String string = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Socket socket = this.serverSocket.accept();
                    if (!this.allow(socket)) {
                        this.trace("Connection not allowed");
                        socket.close();
                        continue;
                    }
                    PgServerThread pgServerThread = new PgServerThread(socket, this);
                    this.running.add(pgServerThread);
                    pgServerThread.setProcessId(this.pid.incrementAndGet());
                    Thread thread = new Thread((Runnable)pgServerThread, string + " thread");
                    thread.setDaemon(this.isDaemon);
                    pgServerThread.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception exception) {
                if (this.stop) break block4;
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        if (!this.stop) {
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.serverSocket = null;
            }
        }
        for (PgServerThread pgServerThread : new ArrayList<PgServerThread>(this.running)) {
            pgServerThread.close();
            try {
                Thread thread = pgServerThread.getThread();
                if (thread == null) continue;
                thread.join(100L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public boolean isRunning(boolean bl) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.serverSocket.getLocalPort(), false);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    PgServerThread getThread(int n) {
        for (PgServerThread pgServerThread : new ArrayList<PgServerThread>(this.running)) {
            if (pgServerThread.getProcessId() != n) continue;
            return pgServerThread;
        }
        return null;
    }

    String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    @Override
    public String getType() {
        return "PG";
    }

    @Override
    public String getName() {
        return "H2 PG Server";
    }

    boolean getIfExists() {
        return this.ifExists;
    }

    public static String getIndexColumn(Connection connection, int n, Integer n2, Boolean bl) throws SQLException {
        if (n2 == null || n2 == 0) {
            PreparedStatement preparedStatement = connection.prepareStatement("select sql from information_schema.indexes where id=?");
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return "";
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select column_name from information_schema.indexes where id=? and ordinal_position=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return "";
    }

    public static String getCurrentSchema(Connection connection) throws SQLException {
        ResultSet resultSet = connection.createStatement().executeQuery("call schema()");
        resultSet.next();
        return resultSet.getString(1);
    }

    public static int getOid(Connection connection, String string) throws SQLException {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select oid from pg_class where relName = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            return 0;
        }
        return resultSet.getInt(1);
    }

    public static String getEncodingName(int n) {
        switch (n) {
            case 0: {
                return "SQL_ASCII";
            }
            case 6: {
                return "UTF8";
            }
            case 8: {
                return "LATIN1";
            }
        }
        return n < 40 ? "UTF8" : "";
    }

    public static String getVersion() {
        return "PostgreSQL 8.2.23 server protocol using H2 " + Constants.getFullVersion();
    }

    public static Timestamp getStartTime() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getUserById(Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT NAME FROM INFORMATION_SCHEMA.USERS WHERE ID=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    public static boolean hasDatabasePrivilege(int n, String string) {
        return true;
    }

    public static boolean hasTablePrivilege(String string, String string2) {
        return true;
    }

    public static int getCurrentTid(String string, String string2) {
        return 1;
    }

    public static String getPgExpr(String string, int n) {
        return null;
    }

    public static String formatType(Connection connection, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("select typname from pg_catalog.pg_type where oid = ? and typtypmod = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    public static int convertType(int n) {
        switch (n) {
            case 16: {
                return 16;
            }
            case 12: {
                return 1043;
            }
            case 2005: {
                return 25;
            }
            case 1: {
                return 1042;
            }
            case 5: {
                return 21;
            }
            case 4: {
                return 23;
            }
            case -5: {
                return 20;
            }
            case 3: {
                return 1700;
            }
            case 7: {
                return 700;
            }
            case 8: {
                return 701;
            }
            case 92: {
                return 1083;
            }
            case 91: {
                return 1082;
            }
            case 93: {
                return 1114;
            }
            case -3: {
                return 17;
            }
            case 2004: {
                return 26;
            }
            case 2003: {
                return 1009;
            }
        }
        return 705;
    }

    HashSet<Integer> getTypeSet() {
        return this.typeSet;
    }

    void checkType(int n) {
        if (!this.typeSet.contains(n)) {
            this.trace("Unsupported type: " + n);
        }
    }

    public String checkKeyAndGetDatabaseName(String string) {
        if (this.key == null) {
            return string;
        }
        if (this.key.equals(string)) {
            return this.keyDatabase;
        }
        throw DbException.get(28000);
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }
}

