/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.schema;

import java.math.BigInteger;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.schema.Schema;
import net.lapismc.datastore.drivers.h2.schema.SchemaObjectBase;
import net.lapismc.datastore.drivers.h2.table.Table;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long value;
    private long valueWithMargin;
    private long increment;
    private long cacheSize;
    private long minValue;
    private long maxValue;
    private boolean cycle;
    private boolean belongsToTable;
    private boolean writeWithMargin;

    public Sequence(Schema schema, int n, String string, long l, long l2) {
        this(schema, n, string, l, l2, null, null, null, false, true);
    }

    public Sequence(Schema schema, int n, String string, Long l, Long l2, Long l3, Long l4, Long l5, boolean bl, boolean bl2) {
        this.initSchemaObjectBase(schema, n, string, 9);
        this.increment = l2 != null ? l2 : 1L;
        this.minValue = l4 != null ? l4 : Sequence.getDefaultMinValue(l, this.increment);
        this.maxValue = l5 != null ? l5 : Sequence.getDefaultMaxValue(l, this.increment);
        this.valueWithMargin = this.value = l != null ? l.longValue() : this.getDefaultStartValue(this.increment);
        this.cacheSize = l3 != null ? Math.max(1L, l3) : 32L;
        this.cycle = bl;
        this.belongsToTable = bl2;
        if (!Sequence.isValid(this.value, this.minValue, this.maxValue, this.increment)) {
            throw DbException.get(90009, string, String.valueOf(this.value), String.valueOf(this.minValue), String.valueOf(this.maxValue), String.valueOf(this.increment));
        }
    }

    public synchronized void modify(Long l, Long l2, Long l3, Long l4) {
        if (l == null) {
            l = this.value;
        }
        if (l2 == null) {
            l2 = this.minValue;
        }
        if (l3 == null) {
            l3 = this.maxValue;
        }
        if (l4 == null) {
            l4 = this.increment;
        }
        if (!Sequence.isValid(l, l2, l3, l4)) {
            throw DbException.get(90009, this.getName(), String.valueOf(l), String.valueOf(l2), String.valueOf(l3), String.valueOf(l4));
        }
        this.value = l;
        this.valueWithMargin = l;
        this.minValue = l2;
        this.maxValue = l3;
        this.increment = l4;
    }

    private static boolean isValid(long l, long l2, long l3, long l4) {
        return l2 <= l && l3 >= l && l3 > l2 && l4 != 0L && BigInteger.valueOf(l4).abs().compareTo(BigInteger.valueOf(l3).subtract(BigInteger.valueOf(l2))) < 0;
    }

    private static long getDefaultMinValue(Long l, long l2) {
        long l3;
        long l4 = l3 = l2 >= 0L ? 1L : Long.MIN_VALUE;
        if (l != null && l2 >= 0L && l < l3) {
            l3 = l;
        }
        return l3;
    }

    private static long getDefaultMaxValue(Long l, long l2) {
        long l3;
        long l4 = l3 = l2 >= 0L ? Long.MAX_VALUE : -1L;
        if (l != null && l2 < 0L && l > l3) {
            l3 = l;
        }
        return l3;
    }

    private long getDefaultStartValue(long l) {
        return l >= 0L ? this.minValue : this.maxValue;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(boolean bl) {
        this.cycle = bl;
    }

    @Override
    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        return "DROP SEQUENCE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public synchronized String getCreateSQL() {
        long l = this.writeWithMargin ? this.valueWithMargin : this.value;
        StringBuilder stringBuilder = new StringBuilder("CREATE SEQUENCE ");
        stringBuilder.append(this.getSQL()).append(" START WITH ").append(l);
        if (this.increment != 1L) {
            stringBuilder.append(" INCREMENT BY ").append(this.increment);
        }
        if (this.minValue != Sequence.getDefaultMinValue(l, this.increment)) {
            stringBuilder.append(" MINVALUE ").append(this.minValue);
        }
        if (this.maxValue != Sequence.getDefaultMaxValue(l, this.increment)) {
            stringBuilder.append(" MAXVALUE ").append(this.maxValue);
        }
        if (this.cycle) {
            stringBuilder.append(" CYCLE");
        }
        if (this.cacheSize != 32L) {
            stringBuilder.append(" CACHE ").append(this.cacheSize);
        }
        if (this.belongsToTable) {
            stringBuilder.append(" BELONGS_TO_TABLE");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNext(Session session) {
        long l;
        boolean bl = false;
        Sequence sequence = this;
        synchronized (sequence) {
            if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
                this.valueWithMargin += this.increment * this.cacheSize;
                bl = true;
            }
            if (this.increment > 0L && this.value > this.maxValue || this.increment < 0L && this.value < this.minValue) {
                if (this.cycle) {
                    this.value = this.increment > 0L ? this.minValue : this.maxValue;
                    this.valueWithMargin = this.value + this.increment * this.cacheSize;
                    bl = true;
                } else {
                    throw DbException.get(90006, this.getName());
                }
            }
            l = this.value;
            this.value += this.increment;
        }
        if (bl) {
            this.flush(session);
        }
        return l;
    }

    public void flushWithoutMargin() {
        if (this.valueWithMargin != this.value) {
            this.valueWithMargin = this.value;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Session session) {
        if (this.isTemporary()) {
            return;
        }
        if (session == null || !this.database.isSysTableLockedBy(session)) {
            Session session2 = this.database.getSystemSession();
            Object object = this.database.isMultiThreaded() ? session2 : this.database;
            synchronized (object) {
                this.flushInternal(session2);
                session2.commit(false);
            }
        }
        Object object = this.database.isMultiThreaded() ? session : this.database;
        synchronized (object) {
            this.flushInternal(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal(Session session) {
        boolean bl = this.database.lockMeta(session);
        try {
            this.writeWithMargin = true;
            this.database.updateMeta(session, this);
        }
        finally {
            this.writeWithMargin = false;
        }
        if (!bl) {
            this.database.unlockMeta(session);
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    public void setCacheSize(long l) {
        this.cacheSize = Math.max(1L, l);
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

