/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.result;

import net.lapismc.datastore.drivers.h2.engine.SessionInterface;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.result.ResultInterface;
import net.lapismc.datastore.drivers.h2.value.Value;

public abstract class LazyResult
implements ResultInterface {
    private final Expression[] expressions;
    private int rowId = -1;
    private Value[] currentRow;
    private Value[] nextRow;
    private boolean closed;
    private boolean afterLast;
    private int limit;

    public LazyResult(Expression[] expressionArray) {
        this.expressions = expressionArray;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    @Override
    public void reset() {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        this.rowId = -1;
        this.afterLast = false;
        this.currentRow = null;
        this.nextRow = null;
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.hasNext()) {
            ++this.rowId;
            this.currentRow = this.nextRow;
            this.nextRow = null;
            return true;
        }
        if (!this.afterLast) {
            ++this.rowId;
            this.currentRow = null;
            this.afterLast = true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.closed || this.afterLast) {
            return false;
        }
        if (this.nextRow == null && (this.limit <= 0 || this.rowId + 1 < this.limit)) {
            this.nextRow = this.fetchNextRow();
        }
        return this.nextRow != null;
    }

    protected abstract Value[] fetchNextRow();

    @Override
    public boolean isAfterLast() {
        return this.afterLast;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public int getRowCount() {
        throw DbException.getUnsupportedException("Row count is unknown for lazy result.");
    }

    @Override
    public boolean needToClose() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public String getAlias(int n) {
        return this.expressions[n].getAlias();
    }

    @Override
    public String getSchemaName(int n) {
        return this.expressions[n].getSchemaName();
    }

    @Override
    public String getTableName(int n) {
        return this.expressions[n].getTableName();
    }

    @Override
    public String getColumnName(int n) {
        return this.expressions[n].getColumnName();
    }

    @Override
    public int getColumnType(int n) {
        return this.expressions[n].getType();
    }

    @Override
    public long getColumnPrecision(int n) {
        return this.expressions[n].getPrecision();
    }

    @Override
    public int getColumnScale(int n) {
        return this.expressions[n].getScale();
    }

    @Override
    public int getDisplaySize(int n) {
        return this.expressions[n].getDisplaySize();
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return this.expressions[n].isAutoIncrement();
    }

    @Override
    public int getNullable(int n) {
        return this.expressions[n].getNullable();
    }

    @Override
    public void setFetchSize(int n) {
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public ResultInterface createShallowCopy(SessionInterface sessionInterface) {
        return null;
    }

    @Override
    public boolean containsDistinct(Value[] valueArray) {
        throw DbException.throwInternalError();
    }
}

