/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.mvstore.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.lapismc.datastore.drivers.h2.engine.Database;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.index.BaseIndex;
import net.lapismc.datastore.drivers.h2.index.Cursor;
import net.lapismc.datastore.drivers.h2.index.IndexType;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.mvstore.MVMap;
import net.lapismc.datastore.drivers.h2.mvstore.db.MVIndex;
import net.lapismc.datastore.drivers.h2.mvstore.db.MVTable;
import net.lapismc.datastore.drivers.h2.mvstore.db.TransactionStore;
import net.lapismc.datastore.drivers.h2.mvstore.db.ValueDataType;
import net.lapismc.datastore.drivers.h2.result.Row;
import net.lapismc.datastore.drivers.h2.result.SearchRow;
import net.lapismc.datastore.drivers.h2.result.SortOrder;
import net.lapismc.datastore.drivers.h2.table.Column;
import net.lapismc.datastore.drivers.h2.table.IndexColumn;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.util.New;
import net.lapismc.datastore.drivers.h2.value.CompareMode;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueArray;
import net.lapismc.datastore.drivers.h2.value.ValueLong;
import net.lapismc.datastore.drivers.h2.value.ValueNull;

public final class MVSecondaryIndex
extends BaseIndex
implements MVIndex {
    final MVTable mvTable;
    private final int keyColumns;
    private final TransactionStore.TransactionMap<Value, Value> dataMap;

    public MVSecondaryIndex(Database database, MVTable mVTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.mvTable = mVTable;
        this.initBaseIndex(mVTable, n, string, indexColumnArray, indexType);
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(indexColumnArray);
        }
        this.keyColumns = indexColumnArray.length + 1;
        String string2 = "index." + this.getId();
        int[] nArray = new int[this.keyColumns];
        for (int i = 0; i < indexColumnArray.length; ++i) {
            nArray[i] = indexColumnArray[i].sortType;
        }
        nArray[this.keyColumns - 1] = 0;
        ValueDataType valueDataType = new ValueDataType(database.getCompareMode(), database, nArray);
        ValueDataType valueDataType2 = new ValueDataType(null, null, null);
        TransactionStore.Transaction transaction = this.mvTable.getTransactionBegin();
        this.dataMap = transaction.openMap(string2, valueDataType, valueDataType2);
        transaction.commit();
        if (!valueDataType.equals(this.dataMap.getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type");
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        MVMap<ValueArray, Value> mVMap = this.openMap(string);
        for (Row row : list) {
            ValueArray valueArray = this.convertToKey(row);
            mVMap.put(valueArray, ValueNull.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferedRows(List<String> list) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>(list);
        CompareMode compareMode = this.database.getCompareMode();
        int n = list.size();
        PriorityQueue<Source> priorityQueue = new PriorityQueue<Source>(n, new Source.Comparator(compareMode));
        for (String object2 : list) {
            object = this.openMap(object2).keyIterator(null);
            if (!object.hasNext()) continue;
            priorityQueue.add(new Source((Iterator<ValueArray>)object));
        }
        try {
            while (!priorityQueue.isEmpty()) {
                Source source = (Source)priorityQueue.remove();
                ValueArray valueArray = source.next();
                if (this.indexType.isUnique()) {
                    object = valueArray.getList();
                    object = (Value[])object.clone();
                    object[this.keyColumns - 1] = ValueLong.MIN;
                    ValueArray valueArray2 = ValueArray.get((Value[])object);
                    SearchRow searchRow = this.convertToSearchRow(valueArray);
                    if (!this.mayHaveNullDuplicates(searchRow)) {
                        this.requireUnique(searchRow, this.dataMap, valueArray2);
                    }
                }
                this.dataMap.putCommitted(valueArray, ValueNull.INSTANCE);
                if (!source.hasNext()) continue;
                priorityQueue.offer(source);
            }
        }
        catch (Throwable throwable) {
            for (String string : arrayList) {
                MVMap<ValueArray, Value> mVMap = this.openMap(string);
                mVMap.getStore().removeMap(mVMap);
            }
            throw throwable;
        }
        for (String string : arrayList) {
            object = this.openMap(string);
            ((MVMap)object).getStore().removeMap((MVMap<?, ?>)object);
        }
    }

    private MVMap<ValueArray, Value> openMap(String string) {
        int[] nArray = new int[this.keyColumns];
        for (int i = 0; i < this.indexColumns.length; ++i) {
            nArray[i] = this.indexColumns[i].sortType;
        }
        nArray[this.keyColumns - 1] = 0;
        ValueDataType valueDataType = new ValueDataType(this.database.getCompareMode(), this.database, nArray);
        ValueDataType valueDataType2 = new ValueDataType(null, null, null);
        MVMap.Builder builder = new MVMap.Builder().keyType(valueDataType).valueType(valueDataType2);
        Object m = this.database.getMvStore().getStore().openMap(string, builder);
        if (!valueDataType.equals(((MVMap)m).getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type");
        }
        return m;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        ValueArray valueArray = this.convertToKey(row);
        ValueArray valueArray2 = null;
        if (this.indexType.isUnique()) {
            valueArray2 = this.convertToKey(row);
            valueArray2.getList()[this.keyColumns - 1] = ValueLong.MIN;
            if (this.mayHaveNullDuplicates(row)) {
                valueArray2 = null;
            } else {
                this.requireUnique(row, transactionMap, valueArray2);
            }
        }
        try {
            transactionMap.put(valueArray, ValueNull.INSTANCE);
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
        if (valueArray2 != null) {
            ValueArray valueArray3;
            Iterator<Value> iterator = transactionMap.keyIterator(valueArray2, true);
            while (iterator.hasNext() && this.compareRows(row, this.convertToSearchRow(valueArray3 = (ValueArray)iterator.next())) == 0) {
                if (transactionMap.isSameTransaction(valueArray3)) continue;
                if (transactionMap.get(valueArray3) != null) {
                    throw this.getDuplicateKeyException(valueArray3.toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    private void requireUnique(SearchRow searchRow, TransactionStore.TransactionMap<Value, Value> transactionMap, ValueArray valueArray) {
        ValueArray valueArray2;
        Value value = transactionMap.ceilingKey(valueArray);
        if (value != null && this.compareRows(searchRow, this.convertToSearchRow(valueArray2 = (ValueArray)value)) == 0) {
            throw this.getDuplicateKeyException(valueArray2.toString());
        }
    }

    @Override
    public void remove(Session session, Row row) {
        ValueArray valueArray = this.convertToKey(row);
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.remove(valueArray);
            if (value == null) {
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw this.mvTable.convertException(illegalStateException);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) {
        TransactionStore.TransactionMap<Value, Value> transactionMap;
        ValueArray valueArray;
        block8: {
            block9: {
                ValueArray valueArray2;
                block7: {
                    valueArray = this.convertToKey(searchRow);
                    if (valueArray != null) {
                        valueArray.getList()[this.keyColumns - 1] = ValueLong.MIN;
                    }
                    transactionMap = this.getMap(session);
                    if (!bl || valueArray == null) break block8;
                    int n = 1;
                    while (true) {
                        if ((valueArray2 = (ValueArray)transactionMap.relativeKey(valueArray, n)) != null) {
                            int n2;
                            Value value;
                            boolean bl2 = false;
                            for (int i = 0; i < this.keyColumns - 1 && (value = searchRow.getValue(n2 = this.columnIds[i])) != null; ++i) {
                                Value value2 = valueArray2.getList()[i];
                                if (this.database.compare(value2, value) <= 0) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2) {
                                n += n;
                                valueArray = valueArray2;
                                continue;
                            }
                        }
                        if (n > 1) {
                            n /= 2;
                            continue;
                        }
                        if (transactionMap.get(valueArray2) != null) break block7;
                        if ((valueArray = (ValueArray)transactionMap.higherKey(valueArray)) == null) break;
                    }
                    break block9;
                }
                valueArray = valueArray2;
            }
            if (valueArray == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
        }
        return new MVStoreCursor(session, transactionMap.keyIterator(valueArray), searchRow2);
    }

    private ValueArray convertToKey(SearchRow searchRow) {
        if (searchRow == null) {
            return null;
        }
        Value[] valueArray = new Value[this.keyColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int n = column.getColumnId();
            Value value = searchRow.getValue(n);
            if (value == null) continue;
            valueArray[i] = value.convertTo(column.getType());
        }
        valueArray[this.keyColumns - 1] = ValueLong.get(searchRow.getKey());
        return ValueArray.get(valueArray);
    }

    SearchRow convertToSearchRow(ValueArray valueArray) {
        Value[] valueArray2 = valueArray.getList();
        Row row = this.mvTable.getTemplateRow();
        row.setKey(valueArray2[valueArray2.length - 1].getLong());
        Column[] columnArray = this.getColumns();
        for (int i = 0; i < valueArray2.length - 1; ++i) {
            Column column = columnArray[i];
            int n = column.getColumnId();
            Value value = valueArray2[i];
            row.setValue(n, value);
        }
        return row;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        try {
            return 10L * this.getCostRangeIndex(nArray, this.dataMap.sizeAsLongMax(), tableFilterArray, n, sortOrder, false, hashSet);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            TransactionStore.Transaction transaction = session.getTransaction();
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        Value value;
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        Value value2 = value = bl ? transactionMap.firstKey() : transactionMap.lastKey();
        while (true) {
            if (value == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
            if (((ValueArray)value).getList()[0] != ValueNull.INSTANCE) break;
            value = bl ? transactionMap.higherKey(value) : transactionMap.lowerKey(value);
        }
        ArrayList arrayList = New.arrayList();
        arrayList.add(value);
        MVStoreCursor mVStoreCursor = new MVStoreCursor(session, arrayList.iterator(), null);
        mVStoreCursor.next();
        return mVStoreCursor;
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, true, searchRow2);
    }

    @Override
    public void checkRename() {
    }

    private TransactionStore.TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction transaction = session.getTransaction();
        return this.dataMap.getInstance(transaction, Long.MAX_VALUE);
    }

    final class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Value> it;
        private final SearchRow last;
        private Value current;
        private SearchRow searchRow;
        private Row row;

        MVStoreCursor(Session session, Iterator<Value> iterator, SearchRow searchRow) {
            this.session = session;
            this.it = iterator;
            this.last = searchRow;
        }

        @Override
        public Row get() {
            SearchRow searchRow;
            if (this.row == null && (searchRow = this.getSearchRow()) != null) {
                this.row = MVSecondaryIndex.this.mvTable.getRow(this.session, searchRow.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = MVSecondaryIndex.this.convertToSearchRow((ValueArray)this.current);
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.searchRow = null;
            if (this.current != null && this.last != null && MVSecondaryIndex.this.compareRows(this.getSearchRow(), this.last) > 0) {
                this.searchRow = null;
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }

    private static final class Source {
        private final Iterator<ValueArray> iterator;
        ValueArray currentRowData;

        public Source(Iterator<ValueArray> iterator) {
            this.iterator = iterator;
            this.currentRowData = iterator.next();
        }

        public boolean hasNext() {
            boolean bl = this.iterator.hasNext();
            if (bl) {
                this.currentRowData = this.iterator.next();
            }
            return bl;
        }

        public ValueArray next() {
            return this.currentRowData;
        }

        public static final class Comparator
        implements java.util.Comparator<Source> {
            private final CompareMode compareMode;

            public Comparator(CompareMode compareMode) {
                this.compareMode = compareMode;
            }

            @Override
            public int compare(Source source, Source source2) {
                return source.currentRowData.compareTo(source2.currentRowData, this.compareMode);
            }
        }
    }
}

