/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.index;

import net.lapismc.datastore.drivers.h2.index.Cursor;
import net.lapismc.datastore.drivers.h2.index.TreeIndex;
import net.lapismc.datastore.drivers.h2.index.TreeNode;
import net.lapismc.datastore.drivers.h2.result.Row;
import net.lapismc.datastore.drivers.h2.result.SearchRow;

public class TreeCursor
implements Cursor {
    private final TreeIndex tree;
    private TreeNode node;
    private boolean beforeFirst;
    private final SearchRow first;
    private final SearchRow last;

    TreeCursor(TreeIndex treeIndex, TreeNode treeNode, SearchRow searchRow, SearchRow searchRow2) {
        this.tree = treeIndex;
        this.node = treeNode;
        this.first = searchRow;
        this.last = searchRow2;
        this.beforeFirst = true;
    }

    @Override
    public Row get() {
        return this.node == null ? null : this.node.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        if (this.beforeFirst) {
            this.beforeFirst = false;
            if (this.node == null) {
                return false;
            }
            if (this.first != null && this.tree.compareRows(this.node.row, this.first) < 0) {
                this.node = TreeCursor.next(this.node);
            }
        } else {
            this.node = TreeCursor.next(this.node);
        }
        if (this.node != null && this.last != null && this.tree.compareRows(this.node.row, this.last) > 0) {
            this.node = null;
        }
        return this.node != null;
    }

    @Override
    public boolean previous() {
        this.node = TreeCursor.previous(this.node);
        return this.node != null;
    }

    private static TreeNode next(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.right;
        if (treeNode2 != null) {
            treeNode = treeNode2;
            TreeNode treeNode3 = treeNode.left;
            while (treeNode3 != null) {
                treeNode = treeNode3;
                treeNode3 = treeNode.left;
            }
            return treeNode;
        }
        TreeNode treeNode4 = treeNode;
        treeNode = treeNode.parent;
        while (treeNode != null && treeNode4 == treeNode.right) {
            treeNode4 = treeNode;
            treeNode = treeNode.parent;
        }
        return treeNode;
    }

    private static TreeNode previous(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode treeNode2 = treeNode.left;
        if (treeNode2 != null) {
            treeNode = treeNode2;
            TreeNode treeNode3 = treeNode.right;
            while (treeNode3 != null) {
                treeNode = treeNode3;
                treeNode3 = treeNode.right;
            }
            return treeNode;
        }
        TreeNode treeNode4 = treeNode;
        treeNode = treeNode.parent;
        while (treeNode != null && treeNode4 == treeNode.left) {
            treeNode4 = treeNode;
            treeNode = treeNode.parent;
        }
        return treeNode;
    }
}

